#include <math.h>
#include "wheel.h"
#include "main.h"

#define WSPEED 20.0f
/* for calculations in radians.. */
#define WSPEED2 (WSPEED*180.0f/PI)

Wheel::Wheel() {}
Wheel::~Wheel() {}

// void Wheel::init(int angle,float hei0,float slope0,float hei1,float slope1) {
  
// }

Cell *Wheel::clone() {
  Wheel *cel = new Wheel();
  cel->init(angle, d, c, a+b+c+d, 3*a+2*b+c);
  return cel;
}

void Wheel::render(Theme *theme) {
  glPushMatrix();
  if (angle==1) {
    glRotatef(90,0,1,0);
    glTranslatef(-1,0,0);
  }

  theme->wheel(this,starting,ending,now/WSPEED,variant);
  glPopMatrix();
}

/* Whether the "tooth" is touching the track at position (x;y). Note
   that radius is *ignored* ! So whatever this function returns only
   makes sense for sq(x)+sq(y) between 0.09 and 0.25 */

bool inTooth(float x,float y,float *delta=0) {
  float devnull;
  if (delta==0) delta=&devnull;

  /* * now/..  : the angle of the wheel

     * atan(..): the angle of the line connecting (x,z,h) to the
       centre of the wheel.
     
     * TWOPI/5 : the angle between two gaps in the wheel
   */

  float t = modff((atan2f(x,-y)-now/WSPEED2)*5/TWOPI,delta);
  if (t<0) { // (wtf?)
    t += 1;
    (*delta) -= 1;
  }

//   printf("wheel %f (%f) car %f (%f) delta=%f+%f\n",now/WSPEED2,(now/WSPEED2)*5/TWOPI,atan2f(x-0.5f,0.4f),atan2f(x-0.5f,0.4f)*5/TWOPI,devnull,t);
  return (t>0.5f);
}

/** returns the smallest y' that is bigger or equal to y and such that
    (x;y') is not in a "tooth" (ignoring the inner disk). The
    coordinate system is centred in the wheel's centre */
float leaveTooth(float x,float y) {
  /* t: angle zero is downwards, and growing angle is towards the
     left. We then subtract the wheel's angle */
  float sidea=0;
  if (inTooth(x,y,&sidea)) {
    /* we're in a tooth! So move up until we either leave the tooth
       or leave the big circle */
    float top = sqrtf(0.25f-sq(x)); // top of big circle

    /* if we're on the right half, go towards the *next* tooth side
       (clockwise). If we're on the left half, go towards the
       *previous* one. */
    if (x>0) sidea -= 0.25f;
    else sidea -= 0.75f;
//     if (x>0) sidea += 0.25f;
//     else sidea -= 1.75f;
    /* angle of the tooth side we're aiming for */
    sidea = now/WSPEED2+sidea*TWOPI/5;
    /* tanf returns the side slope. It's PI- because slope 0 is at
       angle HALFPI (we're actually doing cotf(sidea) */
    float side = -x*tanf(PI-sidea);

    /* negative side happens near the top of the wheel, when the
       tooth is like V (negative slope on the left and positive on the
       right). In that case, just jump to the top of the
       circle. Otherwise, just go up until overtaking either top or
       side.  */
    return (side<y || side>top)?top:side;
  } else return y;
}

float Wheel::height(float x,float y,float z) {
  float h = Smooth::height(x,0,z);
  if (y<h) y=h; // let's put the car on the road for a start
  float rd = Smooth::height(0.5f,0,0.5f);
  /*  if (h==0)
    return 0;
    else {*/
  if (z<0.3f || z>0.7) {
    /* in front or behind the wheel */
    return h;
  }

  /* set (x;y)'s origin to the wheel's centre */
  x -= 0.5f;
  y -= rd+0.4f;

  /* .26 and .10 instead of .25 and .09 to make sure we're really
     outside of the wheel :) (should do that inside inTooth as
     well) */
  if ((sq(x)+sq(y)>0.26f) ||
      (sq(x)+sq(y)>0.10f && !inTooth(x,y))) {
    /* we're outside the wheel. */
    return h;
  }
    
  /* step 1: if we're inside a "tooth", get out of it */

  y = leaveTooth(x,y);

  /* Step 2: see if we're in the inner disk */

  if (sq(x)+sq(y)<0.09f) {
    /* we are... so move up to leave it */
    y = sqrtf(0.09f-sq(x));
  }

  /* Step 3: Oops! Maybe moving out of the inner disk sent us back
     into a tooth! Let's fix that. */

  y = leaveTooth(x,y);
    
  return y+rd+0.4f;

    /*  } */

//   printf("wheel %f (%f) car %f (%f) delta=%f+%f\n",now/WSPEED2,(now/WSPEED2)*5/TWOPI,atan2f(x-0.5f,0.4f),atan2f(x-0.5f,0.4f)*5/TWOPI,devnull,t);


// if (z>=0.3f && z<=0.7 && isBlocking(x))
//     return h+0.1f;
//   else
//     return h;
}

float *Wheel::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  /* normal for frontal shocks (the normal direction doesn't really
     matter if the y component is null) */
  static float frontal[3] = {0,0,1};
  static float n[3];

    float dy = Smooth::height(0.5f,0,0.5f)+0.4f;
    float xr1 = x1-0.5f;
    float yr1 = y1-dy;

    float d1=0;
    bool t1 = inTooth(xr1,yr1,&d1);
//     printf("%f %i\n",d1,t1);


  if ((z1>=0.3f && z1<=0.7f)) {
    /* we ended inside the wheel z-slice */

    float r1 = sq(xr1)+sq(yr1); // (currently squared)
    if ((r1<=0.25f) &&
	(t1 || sq(xr1)+sq(yr1)<=0.09f)) {
      /* we ended up inside the wheel */
      if ((z0<0.3f || z0>0.7f)) {
	/* we started outside the wheel z-slice so this is a frontal
	   shock */
// 	printf("frontal shock\n");
	return frontal;
      } else {
	/* both start- and endpoint are in the wheel z-slice so we
	   hit the side of the wheel */
	float xr0 = x0-0.5f;
	float yr0 = y0-dy;
	float d0=0;
	bool t0 = inTooth(xr0,yr0,&d0);

	if (t0) d0 +=0.5f;
	if (t1) d1 +=0.5f;
// 	printf("%f %i -> %f %i: ",d0,t0,d1,t1);
	r1 = sqrt(r1);

	
	/* There is a possibility that (0) was outside the tooth when
	   it was computed, but the wheel turned, and now it is in
	   one. The following kludge fixes that */
	if (t0 && t1) {
	  float r0 = sq(xr0)+sq(yr0); // (squared)
	  if (r0<0.23) { // EXPERIMENT - there was a lower bound for r0 before
	    /* the kludge is triggered if if both (0) and (1) are
	       inside the same tooth. Then we move (0) counter clock
	       wise. */
// 	    printf("[K] ");
	    d0 += 0.5f;
	    t0 = false;
	  }
	}

	if (t0 || !t1) {
	  /* if we either left a tooth or stayed in one, assume we hit
	     an outward facing part */

	  n[0] = xr1/r1;
	  n[1] = yr1/r1;
// 	  printf("outward:");
	} else { // t1 && !t0
// 	  if (t0) d0 +=0.5f;
// 	  if (t1) d1 +=0.5f;
	  if (d0<d1) {
	    /* going clockwise */
	    n[0] = yr1/r1;
	    n[1] = -xr1/r1;
// 	    printf("cw:");
	  } else {
	    /* going counter clockwise */
	    n[0] = -yr1/r1;
	    n[1] = xr1/r1;
// 	    printf("ccw:");
	  }
	}
	n[2] = 0;
// 	printf("%f,%f,%f\n",n[0],n[1],n[2]);
	return n;
      }
    }
  }
  /* if we didn't hit the wheel, default to checking the track
     itself */
  return Smooth::checkWall(x0,y0,z0,x1,y1,z1);
}

void Wheel::interact(Car *c,float t) {

  /* we have two different interaction modes because I don't want it
     to be too easy to reach the top of the wheel starting from the
     bottom by grabbing a tooth.

     1) On the bottom-facing 45 degrees the car is pushed
     *horizontally* just what is required to prevent it from being
     smashed onto a tooth.

     2) On the rest of the wheel, *if* the car is in contact with it,
     it is *rotated* along the wheel. */

  float delta;
  float p[3];
  float xf,zf;
  c->getPosition(p);
  float x = modff(p[0],&xf);
  float y = p[1];
  float z = modff(p[2],&zf);

  float rx = x-0.5f;
  float rd = Smooth::height(0.5f,0,0.5f);
  float ry = y-rd-0.4f;

  if (fabsf(rx)<-ry) {
    rx -= 0.005f;
//     printf("rx %f ry %f\n",rx,ry);
    /* mode 1 */

    /* If the car is inside the wheel, move it aside */
    if (z>=0.3f && z<=0.7f && sq(rx)+sq(ry)<0.25f && inTooth(rx,ry,&delta)) {
      delta += 1; // not sure why. Found by late night experimentation
      /* angle of the tooth side we're aiming for */
      delta = now/WSPEED2+delta*TWOPI/5;

//       printf("moving %f to ",p[0]);
//       printf("moving to delta:%f \n",delta);
      p[0] = xf+0.5f+tanf(delta)*(-ry);
      p[0] += 0.005f;
//       printf("%f\n",p[0]);
      //     printf("resulting angle:");isBlocking(p[0]-x0);
      c->setPosition(p);
    }
  } else {
    /* mode 2 */
    ry -= 0.01f;
//     printf("mode 2\n");
    if ((sq(rx)+sq(ry)<=0.27f) &&
	(sq(rx)+sq(ry)<=0.10f || inTooth(rx,ry))) {
      ry += 0.01f;
//       printf("rotating\n");
      float r = hypot(rx,ry);
      /* factor 100 as in body.cpp. We should NOT! use now, and do
	 everything with the t parameters instead, to avoid this
	 kludge */
      float ang = atan2f(ry,rx) + 100*t/WSPEED2;
      p[0] = xf+0.5f + cos(ang)*r;
      p[1] = rd+0.4f + sin(ang)*r;
      c->setPosition(p);
    }
  }
}

bool Wheel::preferredAngle(float *angle) {
  *angle = HALFPI;
  return true;
}

void Wheel::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," w %d %f %f %f %f %c%c",angle,a,b,c,d,starting?'[':'-',ending?']':'-');
}
