#include "base.h"
#include "trails.h"

Trails::Trails() {}

Trails::~Trails() {
  delete trails;
}

void Trails::init(int len) {
  this->len = len;
  trails = new float[len*3];
  next = 0;
  tot = 0;
}

void Trails::record(float *pos) {
  for (int i=0;i<3;i++)
    trails[(next*3)+i] = pos[i];

  next ++;

  if (next >= len)
    next = 0;
  else if (next >= tot)
    tot ++;
}

void Trails::render() {
  glBegin(GL_LINE_STRIP);
  glColor3f(1,1,1);
  if (tot>next) {
    for (int i=next;i<tot;i++) {
      glVertex3fv(trails+3*i);
    }
  }
  for (int i=0;i<next;i++) {
    glVertex3fv(trails+3*i);
  }
  glEnd();
}
