#ifndef TRACK_H
#define TRACK_H

class Cell;
class Theme;
//#include "cell.h"
//#include "theme.h"

class Track {
 public:
  Track();
  ~Track();

  /* Builds a hardcoded track. Call this *instead* of init() */
/*   void demoTrack(int id); */

  int getWid();
  int getLen(); // Z size

  Theme *getTheme();

  Cell *getCell(int x,int z);

  float getHeight(float x,float y,float z);

  /* Write the (corner of cell - you want to add 0.5,0.5) starting
     position into the given variables */
  void getStartPoint(int *x,float *y,int *z);
  /* set the start point to the given position. No check is made that
     those values are sane. */
  void setStartPoint(int x,float y,int z);

  /** free the cell at the given position and replace it by the given
      one */
  void setCell(int x,int z,Cell *c);

  void render();
  /* render only that row */
  void renderh(int z);
  /* render only that row */
  void renderv(int z);

  /* Save the track to the given file.
     
     The format is as follows:

Each line is a sequence of space separated items.
     
     First line contains three numbers: width, length and theme.

     Available themes currently are Plain (0), Metal (1) and Lego (2).

     Then each of the width*length following lines specifies a cell,
     traversing the track line by line.

     A cell is specified as follows:

     1) a savepoint number or 0
     2) a '-' or 'l' telling if its a last savepoint.
     3) a cell type:
	'b' for bouncing
	'c' for curve
	'f' for fan
	'l' for straight ("line")
        's' for smooth,
	'w' for wheel,
	'-' for cell (i.e. empty)
     4) the rest depends on the cell type and is basically the
        parameters to the type's init() method (see the relevant .h
        files)
 */
  void save(const char *name);

  /* load a track from the given file. Call this instead of init() for
     loading a readymade track */
  bool load(const char *name);

 private:
  
  int wid;
  int len;

  Theme *theme;
 
  int startx;
  float starty;
  int startz;
  
  Cell **cells;
  
  void doCurve(int angle,int x,int z,float h);

  void doStraight(int angle,int from,int to,int lateral,float (*f)(float,float),float v,bool (*b)(int));
  void doBouncing(int angle,int from,int to,int lateral,float (*f)(float,float),float v,bool (*b)(int));

  void savePoint(int x,int z,int n,bool last);

  /** frees the "cells" array. This is called by init() **/
  void freeMemory();
  /** Allocates a blank unusable track. It is safe to call this more than once */
  void init(int wid,int hei);
};

#endif
