#include <math.h>

#include "track.h"
#include "main.h"

#include "bouncing.h"
#include "curve.h"
#include "smooth.h"
#include "straight.h"

Track::Track() {cells = 0;wid=0;len=0;}
Track::~Track() {
  freeMemory();
}

void Track::freeMemory() {
  for (int i=0;i<wid*len;i++) {
    delete cells[i];
  }
  if (cells)
    delete cells;
}

void Track::init(int wid,int len) {
//   Curve *crv;

//   float h; // lenght of current portion
//   float s = -0.3f; // slope of current portion
//   float c = 0.325f; // curvature of current portion
//   float p = +0.01f; // one more derivative
//   float d = 0.000000005f; // slope divider
  freeMemory();
  this->wid = wid;
  this->len = len;

  cells = new Cell*[wid*len];
}

// float f1(float x,float k) {
//   return 2+cosf(x/3.0f);
// }
// bool b1(int x) {
//   return x<0 || (x>18 && x<22);
// }
// /* The name should be self-explaining */
// bool b45781(int x) {
//   return x==9 || x==10 || x==14 || x==15;
// }

// float f2(float x,float k) {
//   return 2.8604435f+40/(10+sq(x-10));
// }

// bool b2(int x) {
//   return (x>6 && x<14);
// }
// bool b3(int x) {
//   return (x<8 || x>9);
// }

// bool b27(int x) {
//   return (x>2 && x<7);
// }

// float ramp(float x,float k) {
//   return 1+ 30/(5+sq(x-30))-30/401+x*k;
// }

// float peak(float x,float k) {
//   return 3/(1+sq(x-6))-3/101+ramp(x,0)+k;
// }

// float cst(float x,float t) { return t; }
// bool never(int x) { return false; }

// /* Paint a straight segment from (from;lateral) to (to;lateral), using
//    f's values from from to to. The b function says if a position
//    should have a hole. v will be passed as second parameter to f. */
// void Track::doStraight(int angle,int from,int to,int lateral,float (*f)(float,float),float v,bool (*b)(int)) {
//   Straight *str;
//   Smooth *smt;
//   //  Cell *cl;
//   int d,z; // helpers to move around the cell[] array
//   if (angle==0) {
//     z = lateral;
//     d = wid;
//   } else {
//     z = lateral*wid;
//     d = 1;
//   }

//   for (int i=from;i<to;i++) {
//     if (b(i)) {
//       cells[z+d*i] = new Cell();
//       cells[z+d*i]->init();
//     } else {
//       float s0 = (f(i+0.01f,v)-f(i,v))/0.01f;
//       float s1 = (f(i+1.01f,v)-f(i+1,v))/0.01f;
//       if (s0==s1) {
// 	str = new Straight();
// 	str->init(angle,f(i+1,v)-f(i,v),f(i,v));
// 	if (b(i-1))
// 	  str->putWall(1+angle,true);
// 	if (b(i+1))
// 	  str->putWall(3-3*angle,true);

// 	cells[z+d*i] = str;
//       } else { // s0!=s1
// 	smt = new Smooth();
// 	smt->init(angle,f(i,v),s0,f(i+1,v),s1);
// 	if (b(i-1))
// 	  smt->putWall(1+angle,true);
// 	if (b(i+1))
// 	  smt->putWall(3-3*angle,true);
// 	cells[z+d*i] = smt;
//       }
//     }
//   }
// }

// void Track::doCurve(int angle,int x,int z,float h){
//   Curve *crv =  new Curve();
//   crv->init(angle,0,h);
//   cells[x+z*wid] = crv;
// }

// /* I'm in a copy-pasty-mood today */
// void Track::doBouncing(int angle,int from,int to,int lateral,float (*f)(float,float),float v,bool (*b)(int)) {
//   Bouncing *str;
//   //  Cell *cl;
//   int d,z; // helpers to move around the cell[] array
//   if (angle==0) {
//     z = lateral;
//     d = wid;
//   } else {
//     z = lateral*wid;
//     d = 1;
//   }

//   for (int i=from;i<to;i++) {
//     if (b(i)) {
//       cells[z+d*i] = new Cell();
//       cells[z+d*i]->init();
//     } else {
//       str = new Bouncing();
//       str->init(angle,1,300,f(i,v));
//       if (b(i-1))
// 	str->putWall(1+angle,true);
//       if (b(i+1))
// 	str->putWall(3-3*angle,true);
//       cells[z+d*i] = str;
//     }
//   }
// }

// void Track::savePoint(int x,int z,int n,bool last) {
//   cells[x+z*wid]->setSavePoint(n,last);
// }

// void Track::demoTrack(int id) {

//   init(40,40);

//   startx = 1;
//   starty = 10;
//   startz = 0;

//   for (int i=0;i<wid*len;i++) {
//     cells[i] = 0;
//   }

//   if (id==1) {

//     float debug = (peak(30,0)-peak(20,0)-(ramp(30,0)-ramp(6,0)))/24;
//     //  printf("%f %f %f %f\n",peak(20,0),ramp(6,debug),ramp(30,debug),peak(30,0));
//     float rd = ramp(6,debug)-peak(20,0);

//     doStraight(1,1,5,0,cst,peak(1,rd),never); // 1
//     doCurve(1,5,0,peak(1,rd));
//     doStraight(0,1,20,5,peak,rd,never); // 2
//     doCurve(3,5,20,peak(20,rd));
//     doStraight(1,6,30,20,ramp,debug,never); // 3
//     doCurve(0,30,20,ramp(30,debug));
//     doStraight(0,11,20,30,cst,peak(30,rd),never); // 4
//     doCurve(1,30,10,peak(30,rd));
//     doStraight(1,6,30,10,peak,rd,b27); // 5
//     doStraight(1,1,5,10,peak,rd,b27); // 6
//     doCurve(3,0,10,peak(1,rd));
//     doStraight(0,1,10,0,cst,peak(1,rd),never); // 7
//     doCurve(2,0,0,peak(1,rd));

//     savePoint(1,0,1,false);
//     savePoint(5,15,2,false);
//     savePoint(15,10,3,false);
//     savePoint(0,5,4,true);

//   } else {
//     float h;
//     Curve *crv;

//     doStraight(1,1,wid-1,0,f1,0,b1);

//     h = f1(wid-1,0);

//     crv =  new Curve();
//     crv->init(1,0,h);
//     cells[wid-1] = crv;

//     doStraight(0,1,len-1,wid-1,cst,h,never);

//     crv =  new Curve();
//     crv->init(0,0,h);
//     cells[(len-1)*wid+(wid-1)] = crv;

//     doStraight(1,1,8,len-1,f2,0,b2);
//     doBouncing(1,8,10,len-1,cst,5,b3);
//     doStraight(1,10,wid-1,len-1,f2,0,b2);

//     h = f2(1,0);

//     crv =  new Curve();
//     crv->init(3,0,h);
//     cells[(len-1)*wid] = crv;

//     doStraight(0,14,len-1,0,cst,h,b45781);

//     h = f1(1,0);

//     doBouncing(0,11,14,0,cst,h,b45781);
//     doStraight(0,1,11,0,cst,h,b45781);

//     crv =  new Curve();
//     crv->init(2,0,h);
//     cells[0] = crv;

//     //   for (int y=1;y<len-1;y++) {
//     //     current = new Straight();
//     //     current->init(0,0,h);
//     //     cells[wid*y] = current;
//     //   }

//   /* A couple of save points */
//   cells[1]->setSavePoint(1,false);
//   cells[30]->setSavePoint(2,false);
//   cells[wid-1 + 10*wid]->setSavePoint(3,false);
//   cells[30+(len-1)*wid]->setSavePoint(4,false);
//   cells[30*wid]->setSavePoint(5,true);

//   }

//    /* blanks in the middle of the track */

//   int i=0;
//   for (int z=0;z<len;z++) {
//     for (int x=0;x<wid;x++) {
//       if (!cells[i]) {
// 	cells[i] = new Cell();
// 	cells[i]->init();
//       }
//       cells[i++]->setCoordinates(x,z);
//     }
//   }

// }

int Track::getWid() {
  return wid;
}

int Track::getLen() {
  return len;
}

Theme *Track::getTheme() {
  return theme;
}

Cell *Track::getCell(int x,int z) {
  if (x<0 || x>=wid || z<0 || z>=len) return &borderCell;

  return cells[x+wid*z];
}

float Track::getHeight(float x,float y,float z) {
  int xf = (int)floorf(x);
  int zf = (int)floorf(z);
  Cell *c = getCell(xf,zf);
  float tr = c->height(x-xf,y,z-zf);
  //  float *n2 = c2->normal(x-xf2,y,z-zf2);
  return tr;
}

void Track::getStartPoint(int *x,float *y,int *z) {
  *x = startx;
  *y = starty;
  *z = startz;
}

void Track::setStartPoint(int x,float y,int z) {
//   printf("setting start point to %d %d\n",x,z);
  startx = x;
  starty = y;
  startz = z;
}

void Track::setCell(int x,int z,Cell *c) {
  if (x<0 || x>=wid || z<0 || z>=len) return;

  delete cells[x+wid*z];
  cells[x+wid*z] = c;
  c->setCoordinates(x,z);
}

void Track::renderh(int z) {
  for (int x=0;x<wid;x++) {
    glPushMatrix();
    glTranslatef(x,0,z);

    getCell(x,z)->render(theme);

    glPopMatrix();
  }
}

void Track::renderv(int x) {
  for (int z=0;z<len;z++) {
    glPushMatrix();
    glTranslatef(x,0,z);

    getCell(x,z)->render(theme);

    glPopMatrix();
  }
}

void Track::render() {
  glPushMatrix();
  for (int z=0;z<len;z++) {
    renderh(z);
  }
  glPopMatrix();
}

void Track::save(const char *fname) {
  FILE *f = fopen(fname,"w");
  fprintf(f,"%d %d %d\n",wid,len,theme->number());
  for (int z=0;z<len;z++) {
    for (int x=0;x<wid;x++) {
      //      printf("%d %d %x\n",x,z,getCell(x,z));
      getCell(x,z)->writeTo(f);
      fprintf(f,"\n");
    }
  }
  fclose(f);
}

bool Track::load(const char *fname) {
  FILE *f = fopen(fname,"r");
  int w,h,tn;
  int i;
  int zero=0;
  Cell *c;
  if (!f) return false;

  if (fscanf(f,"%d %d %d\n",&w,&h,&tn)<2) return false;

  if (w<0 || h<0) {
    fclose(f);
    return false;
  }

  switch (tn) {
//   case 0: theme = plainTheme;
//     break;
  case 1: theme = metalTheme;
    break;
  case 2: theme = legoTheme;
    break;
  default:
    theme = plainTheme;
  }

  init(w,h);

  i=0;
  for (int z=0;z<len;z++) {
    for (int x=0;x<wid;x++) {
      c = readFrom(f);
      if (!c) {
	printf("error reading cell %d %d (%i)\n",x,z,i);
	return false; // that will probably segfault but anyway
      }
      c->setCoordinates(x,z);
      if (c->isSavePoint(&zero)>1) {
	startx = x;
	/* second argument large enough to make sure we don't start
	   below the track. I'm assuming the track doesn't start
	   higher than that. */
	starty = c->height(0.5f,1000.0f,0.5f);
	startz = z;
	zero = 0; // yes, believe me, it really is!
      }
      cells[i++] = c;
    }
  }
  
  fclose(f);

  //  exit(0);

  return true;
}
