/* $Id: tools_glPerspective.cpp,v 1.1 2004/03/26 07:24:21 baloo Exp $ */

#include <math.h>
#include <png.h>

extern "C" { 
#include "jpeglib.h" 
}

#include "base.h"
#include "tools.h"

float blueshine[] = {0.1f,0.3f,1.0f,1.0f};
float black[] = {0,0,0,1.0f};
float bright[] = {0.9f,0.9f,0.9f,1.0f};
float red[] = {1,0,0,1};
float darkred[] = {0.8f,0,0,1};
float green[] = {0,1,0,1};
float greenblue[] = {0,0.4f,0.1f,1};
float olive[] = {0,0.2f,0,1};
float pistacchio[] = {0.3f,0.9f,0.3f,1};
float blue[] = {0,0,1,1};
float yellow[] = {1,1,0,1};

/**
 *	Replaces gluPerspective, sets the frustum to perspective mode.
 *	@param fovY	  : Field of vision in degrees in the y direction
 *	@param aspect : Aspect ratio of the viewport
 *	@param zNear  : The near clipping distance
 *	@param zFar	  : The far clipping distance
 */
void glPerspective( GLdouble fovY, GLdouble aspect, GLdouble zNear, GLdouble zFar )
{
	//	Very long (& in theory accurate!) version of Pi. Hopefully an optimizing compiler
	//	will replace references to this with the value!
	const GLdouble pi = 3.1415926535897932384626433832795;

	//	Half of the size of the x and y clipping planes.
	GLdouble fW, fH;

	//	Calculate the distance from 0 of the y clipping plane. Basically trig to calculate
	//	position of clipper at zNear.

	//	Note:	tan( double ) uses radians but OpenGL works in degrees so we convert
	//			degrees to radians by deviding by 180 then multiplying by pi.
	fH = tan( fovY / 180 * pi ) * zNear / 2;

	//	Calculate the distance from 0 of the x clipping plane based on the aspect ratio.
	fW = fH * aspect;

	//	Finally call glFrustum, this is all gluPerspective does anyway!
	//	This is why we calculate half the distance between the clipping planes - glFrustum
	//	takes an offset from zero for each clipping planes distance. (Saves 2 divides)
	glFrustum( -fW, fW, -fH, fH, zNear, zFar );
}

bool loadTexture(const char *file, GLuint *id) {
  // Returns in texture_id the first integer of MAX_NUM_TEXTURES consecutive
  // unused integers for texture.
  glGenTextures(1, id);

//   printf("created texture %d out of %s (error? %d)\n",*id,file,glGetError());

  struct  jpeg_decompress_struct cinfo;   // les infos du fichiers
  struct  jpeg_error_mgr jerr;            // les erreurs
  unsigned char *ligne;                   // une ligne (?)
  int  ImageSize;                         // Taille de l'image
  cinfo.err = jpeg_std_error( &jerr );
  jpeg_create_decompress( &cinfo );
  FILE *fichier = fopen( file,"rb" );  
  if ( fichier == NULL ) {
    cerr << "Error opening texture file." << endl;
    return false;
  }
  
  jpeg_stdio_src( &cinfo, fichier );
  jpeg_read_header( &cinfo, TRUE ); 
  jpeg_start_decompress ( &cinfo );  
  ImageSize = cinfo.image_width * cinfo.image_height * 3;//channels;
  
//   width = cinfo.image_width;
//   height = cinfo.image_height;
//     stride = cinfo.image_width*channels;    
  
  unsigned char *pData = new unsigned char [ImageSize]; /* are we supposed to free this after binding? */
  if ( pData == NULL ) {
    cerr << "Error allocating image memory" << endl;
    fclose (fichier);
    return false;    
  }
  
  ligne = pData;
  
  while ( cinfo.output_scanline < cinfo.output_height )
    {
      ligne = pData + cinfo.image_width * cinfo.output_scanline * 3; // channels
      jpeg_read_scanlines ( &cinfo, &ligne, 1 );
    }
  
  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);
  
  fclose (fichier);
  
//   char pData[256*256*3];
//   int p=0;
//   for (int y=0;y<256;y++) for (int x=0;x<256;x++) {
//       pData[p++] = x&y;
//       pData[p++] = x&y;
//       pData[p++] = x&y;
//     }
  
  
  glBindTexture(GL_TEXTURE_2D, *id);

  glTexImage2D( GL_TEXTURE_2D, 0, 3, cinfo.image_width, cinfo.image_height, 
				0, GL_RGB, GL_UNSIGNED_BYTE, pData );

  delete pData;

  if (glGetError()) {
    printf("error in glTexImage2D: %d\n",glGetError());
    return false;
  }

  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT ); 
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );

  return true;
}

bool loadTexture_png(const char *file, GLuint *id) {
  glGenTextures(1, id);

  int  ImageSize;                         // Taille de l'image

  FILE *fichier = fopen( file,"rb" );  
  if ( fichier == NULL ) {
    cerr << "Error opening texture file." << endl;
    return false;
  }

  /* I commented out the check that we're indeed dealing with a png
     file - I think libpng does this automatically when doing the
     actual loading anyway */

//   fread(header, 1, number, fp);
//   is_png = !png_sig_cmp(header, 0, number);
//   if (!is_png) {
//     printf("%s is not a png file\n",file);
//     return false;
//   }

/* (why do image loading libraries always have to be that complicated?
   What's wrong with just a data = load_my_picture(FILE *f); ?? ) */
  png_structp png_ptr = png_create_read_struct
    (PNG_LIBPNG_VER_STRING,0,0,0); // don't use custom error handling.

  if (!png_ptr) {
    fclose(fichier);
    return false;
  }

  png_infop info_ptr = png_create_info_struct(png_ptr);
  if (!info_ptr) {
      png_destroy_read_struct(&png_ptr,
			      (png_infopp)NULL, (png_infopp)NULL);
      fclose(fichier);
      return false;
  }

  png_infop end_info = png_create_info_struct(png_ptr);
  if (!end_info) {
      png_destroy_read_struct(&png_ptr, &info_ptr,
			      (png_infopp)NULL);
      fclose(fichier);
      return false;
  }
  png_init_io(png_ptr, fichier);
  png_read_png(png_ptr, info_ptr, PNG_TRANSFORM_IDENTITY, NULL);

  fclose(fichier);

  png_byte **row_pointers = png_get_rows(png_ptr, info_ptr);
  int width = png_get_image_width(png_ptr,
				  info_ptr);
  int height=png_get_image_height(png_ptr,
				  info_ptr);
  ImageSize = width * height * 4;
  
//   printf("loaded png file %d x %d\n",width,height);

  unsigned char *pData = new unsigned char [ImageSize]; /* are we supposed to free this after binding? */
  if ( pData == NULL ) {
    cerr << "Error allocating image memory" << endl;
    png_destroy_read_struct(&png_ptr, &info_ptr,
			    (png_infopp)NULL);
    return false;    
  }
  
  /* I suspect the library doesn't allocate the rows in a single
     chunk, so we need to copy them in one. */
  for (int y=0;y<height;y++) {

  
//      for (int x=0;x<512;x++) {
//       pData[y*width+x*4+0] = x&y;
//       pData[y*width+x*4+1] = x&y;
//       pData[y*width+x*4+2] = x&y;
//       pData[y*width+x*4+3] = 128;
//     }

    memcpy(pData+width*4*y,row_pointers[y],width*4);
  }

  png_destroy_read_struct(&png_ptr, &info_ptr,
			      (png_infopp)NULL);

  glBindTexture(GL_TEXTURE_2D, *id);

  glTexImage2D( GL_TEXTURE_2D, 0, 4, width, height, 
				0, GL_RGBA, GL_UNSIGNED_BYTE, pData );
  if (glGetError()) {
    printf("error in glTexImage2D: %d\n",glGetError());
    return false;
  }

  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT ); 
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );

  return true;
}

float sq(float x) { return x*x; }

bool el(FILE *s) {
  char c;
  if (fread(&c,1,1,s)!=1) return false;
  if (c!='\n') {
    printf("Newline expected\n");
    return false;
  }
  return true;
}

void printDigit(int n) {
  glBegin(GL_LINES);
  if (n!=1 && n!=4) { // top
    glVertex3f(0,2,0);
    glVertex3f(1,2,0);
  }
  if (n!=1 && n!=2 && n!=3 && n!=7) { // top left
    glVertex3f(0,2,0);
    glVertex3f(0,1,0);
  }
  if (n!=0 && n!=1 && n!=7) { // middle
    glVertex3f(0,1,0);
    glVertex3f(1,1,0);
  }
  if (n!=5 && n!=6) { // top right
    glVertex3f(1,2,0);
    glVertex3f(1,1,0);
  }
  if (n==0 || n==2 || n==6 || n==8) { // bottom left
    glVertex3f(0,1,0);
    glVertex3f(0,0,0);
  }
  if (n!=1 && n!=4 && n!=7) { // bottom
    glVertex3f(0,0,0);
    glVertex3f(1,0,0);
  }
  if (n!=2) { // bottom right
    glVertex3f(1,1,0);
    glVertex3f(1,0,0);
  }
  glEnd();
}

void printNumber(int n,int s) {
  int i = 0; // how many digits printed so far
  while (n!=0 || i<s) {
    glTranslatef(-1.2f,0,0);
    printDigit(n%10);
    n = (n-(n%10))/10;
    i++;
  }
}

void printTime(int n) {
  printNumber((int)floorf(n/100.0f)%10,1); // subseconds
  glBegin(GL_POINTS);glVertex3f(-0.3f,0,0);glEnd();
  glTranslatef(-0.3f,0,0);
  printNumber((int)floorf(n/1000.0f)%60,2); // seconds
  glBegin(GL_POINTS);glVertex3f(-0.3f,0,0);glEnd();
  glTranslatef(-0.3f,0,0);
  printNumber((int)floorf(n/60000.0f)%60,2); // minutes
}
