#ifndef THEME_H
#define THEME_H

//class Theme;
class Smooth;

//#include "smooth.h"

/** handles everything visual in the game. Switching between different
    themes will change the visible aspect of the game but not the
    behaviour.

    Then any part of the code wanting to render something (except
    maybe Car::renderInfo()) should call the corresponding method in
    this class.

    Many functions take a "Smooth" parameter, because that class
    contains code for computing normals on track surface...
*/

class Theme {
 public:
  Theme();
  ~Theme();

  virtual bool init();

  virtual int number(); // theme number, for use in track files

  virtual void car(float *colour);

  /* track parts follow */
  virtual void cell(int variant);

  virtual void straightSides(Smooth *s,bool starting,bool ending,int variant);
  virtual void straight(Smooth *s,bool starting,bool ending,bool startPoint,float interactAge,int variant);
  virtual void curve(float h,int variant);
  /* angle is the fan angle, not the road angle */
  virtual void fan(Smooth *s,bool starting,bool ending,float angle,int variant);
  /* angle is the wheel angle, not the road angle */
  virtual void wheel(Smooth *s,bool starting,bool ending,float angle,int variant);
};

#endif
