#include <math.h>

#include "theme.h"
#include "base.h"
#include "cell.h"
#include "smooth.h"

/* for straight */
#define ISMOOTHNESS 10
#define SSMOOTHNESS 10.0f

/* for curve */
#define CSMOOTHNESS 15
#define TOOCSMOOTH (2*CSMOOTHNESS)

/* for wheel */
/* cos(pi/5)/2 */
#define WHEELX 0.9510565162951535312
/* sin(pi/5)/2 */
#define WHEELY 0.3090169943749473958

Theme::Theme() {}
Theme::~Theme() {}

bool Theme::init() {
  return true;
}

int Theme::number() {
  return 0;
}

void Theme::car(float *colour) {

  glScalef(0.03f,0.03f,0.03f);

  glBegin(GL_QUAD_STRIP);
  glColor3fv(colour);
  /* back */

  glNormal3f(0,0,-1);
  glVertex3f( 0.9f,0,-1);
  glVertex3f(-0.9f,0,-1);

  glNormal3f(0,SQHALF,-SQHALF);
  glVertex3f( 0.9f,1,-1);
  glVertex3f(-0.9f,1,-1);
  /* top */
  glNormal3f(0,SQHALF,SQHALF);
  glVertex3f( 0.9f,1, 1);
  glVertex3f(-0.9f,1, 1);
  /* front */
  glNormal3f( 0,0, 1);
  glVertex3f( 0.9f,0, 1);
  glVertex3f(-0.9f,0, 1);
  glEnd();
  glBegin(GL_QUADS);

  /* left */
  glNormal3f(-SQTHIRD,SQTHIRD,-SQTHIRD);
  glVertex3f(-0.9f,1,-1);
  glNormal3f(-SQHALF,0,-SQHALF);
  glVertex3f(-0.9f,0,-1);
  glNormal3f(-SQHALF,0,SQHALF);
  glVertex3f(-0.9f,0, 1);
  glNormal3f(-SQTHIRD,SQTHIRD,SQTHIRD);
  glVertex3f(-0.9f,1, 1);

  /* right */
  glNormal3f(SQHALF,0,-SQHALF);
  glVertex3f( 0.9f,0,-1);
  glNormal3f(SQTHIRD,SQTHIRD,-SQTHIRD);
  glVertex3f( 0.9f,1,-1);
  glNormal3f(SQTHIRD,SQTHIRD,SQTHIRD);
  glVertex3f( 0.9f,1, 1);
  glNormal3f(SQHALF,0,SQHALF);
  glVertex3f( 0.9f,0, 1);
  glEnd();

  glBegin(GL_QUADS);
  glColor3f(0,0,0);
  glNormal3f(1,0,0);

  glVertex3f(-1,0,-0.9f);
  glVertex3f(-1,0,-0.6f);
  glVertex3f(-1,0.3f,-0.6f);
  glVertex3f(-1,0.3f,-0.9f);


  glVertex3f(-1,0,0.6f);
  glVertex3f(-1,0,0.9f);
  glVertex3f(-1,0.3f,0.9f);
  glVertex3f(-1,0.3f,0.6f);

  glEnd();

}

  /* track parts follow */
void Theme::cell(int variant) {}

void Theme::straightSides(Smooth *s,bool starting,bool ending,int variant) {
  float g=0;

  glPushMatrix();
//   if (angle==1) {
//     glRotatef(90,0,1,0);
//     glTranslatef(-1,0,0);
//   }

  glBegin(GL_QUADS);

  for (int t=0;t<ISMOOTHNESS;t++) {
    if (t==ISMOOTHNESS/2) g = 1-g;
    glColor3f(1,g,g);

    /* left */
    glNormal3f(-1,0,0);
    glVertex3f(0.2f,0,t/SSMOOTHNESS);
    glVertex3f(0.2f,0,(t+1)/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0((t+1)/SSMOOTHNESS),(t+1)/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);

    /* right */
    glNormal3f(1,0,0);
    glVertex3f(0.8f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);
    glVertex3f(0.8f,s->height0((t+1)/SSMOOTHNESS),(t+1)/SSMOOTHNESS);
    glVertex3f(0.8f,0,(t+1)/SSMOOTHNESS);
    glVertex3f(0.8f,0,t/SSMOOTHNESS);
  }

  glColor3f(1,0,0);

  if (starting) {
    glNormal3f(0,0,-1);
    glVertex3f(0.8f,0,0);
    glVertex3f(0.2f,0,0);
    glVertex3f(0.2f,s->height0(0),0);
    glVertex3f(0.8f,s->height0(0),0);
  }
  if (ending) {
    glNormal3f(0,0,1);
    glVertex3f(0.2f,0,1);
    glVertex3f(0.8f,0,1);
    glVertex3f(0.8f,s->height0(1),1);
    glVertex3f(0.2f,s->height0(1),1);
  }

  glEnd();



  /** DEBUG: render a line 0.7 units above the track, for checking
      camera behaviour */
//   glBegin(GL_LINE_STRIP);
//   glColor3f(1,1,1);
//   for (int t=0;t<=ISMOOTHNESS;t++) {
//     glVertex3f(0.5f,s->height0(t/SSMOOTHNESS)+0.7f,t/SSMOOTHNESS);
//   }
//   glEnd();
  /* debugging ends here */

  glPopMatrix();

}

void Theme::straight(Smooth *s,bool starting,bool ending,bool savePoint,float interactAge,int variant) {
  float g=0;
//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();

  /* sides */
  /*  // code to paint normals follows... 
  glBegin(GL_LINES); {
    glColor3f(1,1,1);
    for (int t=0;t<4;t++) {
      float *n = s->normal0(t*0.25f);
      glVertex3f(0.5f,s->height0(t*0.25f),t*0.25f);
      glVertex3f(0.5f+n[0],s->height0(t*0.25f)+n[1],t*0.25f+n[2]);
    }    
  }
  glEnd();
  */

  straightSides(s,starting,ending,variant);

  glBegin(GL_QUADS);

  for (int t=0;t<ISMOOTHNESS;t++) {
    if (t==ISMOOTHNESS/2) g = 1-g;
    /* top */
    glColor3f(savePoint?0:1,0.8f+g*0.1f,0.1f+g*0.1f);
    glNormal3fv(s->normal0(t/SSMOOTHNESS));
    glVertex3f(0.8f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);
    glNormal3fv(s->normal0((t+1)/SSMOOTHNESS));
    glVertex3f(0.2f,s->height0((t+1)/SSMOOTHNESS),((t+1)/SSMOOTHNESS));
    glVertex3f(0.8f,s->height0((t+1)/SSMOOTHNESS),((t+1)/SSMOOTHNESS));
  }

  glEnd();

}
void Theme::curve(float hei,int variant) {
   float g=0;
//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();

  /* sides */
  glBegin(GL_QUADS);

  for (int i=0;i<CSMOOTHNESS;i++) {
    if (i%3==0) g = 1-g;

     glColor3f(1,g,g);

     /* left */
     glNormal3f(-cosf(i*(PI/TOOCSMOOTH)),0,-sinf(i*(PI/TOOCSMOOTH)));
     glVertex3f(cosf(i    *(PI/TOOCSMOOTH))*0.2f,hei,sinf(i    *(PI/TOOCSMOOTH))*0.2f);
     glVertex3f(cosf(i    *(PI/TOOCSMOOTH))*0.2f,0,  sinf(i    *(PI/TOOCSMOOTH))*0.2f);
     glNormal3f(-cosf((i+1)*(PI/TOOCSMOOTH)),0,-sinf((i+1)*(PI/TOOCSMOOTH)));
     glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.2f,0,  sinf((i+1)*(PI/TOOCSMOOTH))*0.2f);
     glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.2f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.2f);

     /* right */
     glNormal3f(cosf(i*(PI/TOOCSMOOTH)),0,sinf(i*(PI/TOOCSMOOTH)));
     glVertex3f(cosf(i    *(PI/TOOCSMOOTH))*0.8f,0,  sinf(i    *(PI/TOOCSMOOTH))*0.8f);
     glVertex3f(cosf(i    *(PI/TOOCSMOOTH))*0.8f,hei,sinf(i    *(PI/TOOCSMOOTH))*0.8f);
     glNormal3f(cosf((i+1)*(PI/TOOCSMOOTH)),0,sinf((i+1)*(PI/TOOCSMOOTH)));
     glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.8f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.8f);
     glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.8f,0,  sinf((i+1)*(PI/TOOCSMOOTH))*0.8f);
     // }

//   if (starting) {
//     glNormal3f(0,0,-1);
//     glVertex3f(0.2f,0,0);
//     glVertex3f(0.8f,0,0);
//     glVertex3f(0.8f,hei,0);
//     glVertex3f(0.2f,hei,0);
//   }
//   if (ending) {
//     glNormal3f(0,0,1);
//     glVertex3f(0.2f,0,1);
//     glVertex3f(0.2f,hei+slope,1);    
//     glVertex3f(0.8f,hei+slope,1);
//     glVertex3f(0.8f,0,1);
//   }

//  glColor3f(1,0.9f,0.2f);
     /* top */
     glNormal3f(0,1,0);
  // for (int i=0;i<4;i++) {
  //    if (i==2) glColor3f(1,0.8f,0.1f);
     glColor3f(1,0.8f+g/10,0.1f+g/10);

    glVertex3f(cosf(i*(PI/TOOCSMOOTH))*0.8f,hei,sinf(i*(PI/TOOCSMOOTH))*0.8f);
    glVertex3f(cosf(i*(PI/TOOCSMOOTH))*0.2f,hei,sinf(i*(PI/TOOCSMOOTH))*0.2f);
    glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.2f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.2f);
    glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.8f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.8f);
  }

  glEnd();

}
  /* angle is the fan angle, not the road angle */
void Theme::fan(Smooth *s,bool starting,bool ending,float angle,int variant) {
  straightSides(s,starting,ending,variant);
  glPushMatrix();
  glTranslatef(0.5f,s->height0(0.5f),0.5f);
  glRotatef(angle,0,1,0);
  glColor3f(0.1f,0.3f,0.7f);
  glDisable(GL_CULL_FACE);
  for (int i=0;i<3;i++) {
    glBegin(GL_TRIANGLES);
    glVertex3f(0,0,0);
    glVertex3f(0.4f,0,0);
    glVertex3f(0.3f,-0.2f,0.2f);
    glEnd();
    glRotatef(120,0,1,0);
  }
  glEnable(GL_CULL_FACE);
  glPopMatrix();
  
}
  /* angle is the wheel angle, not the road angle */
void Theme::wheel(Smooth *s,bool starting,bool ending,float angle,int variant) {
  straight(s,starting,ending,false,10000,variant);

  static float blue[] = {0.1f,0.3f,1.0f,1.0f};
  static float black[] = {0,0,0,1.0f};

  float f = 0.5f;

  /* debug display starts */
//   glColor3f(1,0,0);
//   glBegin(GL_LINES);
//   for (int i=0;i<40;i++) {
//     glVertex3f(i/40.0f,0.7f,0.29f);
//     glVertex3f(i/40.0f,height(i/40.0f,0.7f,0.5f),0.29f);
//   }
//   glEnd();
  /* debug display ends */

  glTranslatef(0.5f,s->height0(0.5f)+0.4f,0);

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blue);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  glColor3f(0.7f,0.7f,0.7f);
  glRotatef(angle,0,0,1);
  for (int i=0;i<20;i++) {
    if (i%2==0) {
      /* "tooth" side */
      glBegin(GL_QUADS);
      glNormal3f(0,1,0);
      glVertex3f(0,-f,0.7f);
      glVertex3f(0,-f,0.3f);
      
      f = 0.8f-f;
//       f = 0.5f-f;

      glVertex3f(0,-f,0.3f);
      glVertex3f(0,-f,0.7f);
      glEnd();
    }
    glNormal3f(0,0,-1);
    glBegin(GL_TRIANGLES);
    /* front */
    glVertex3f(0,-0,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(0,-f,0.3f);

    /* back */
    glVertex3f(0,-0,0.7f);
    glVertex3f(0,-f,0.7f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();

    /* side */
    glBegin(GL_QUADS);
    glNormal3f(1,0,0);
    glVertex3f(0,-f,0.7f);
    glVertex3f(0,-f,0.3f);

    glNormal3f(WHEELX,WHEELY,0);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();
    glRotatef(18,0,0,1);
  }

  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,0);
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
}

//void Theme::bouncing() {}
