#ifndef STRAIGHT_H
#define STRAIGHT_H

#include "cell.h"

/* A straight track segment */

class Straight : public Cell {
 public:
  Straight();
  ~Straight();

  bool init(int angle,float slope,float hei);
  Cell *clone();
  void putWall(int side,bool wall);

  void render(Theme *theme);

  float height(float x,float y,float z);
  float *normal(float x,float y,float z);
  bool isConnected(int side);
  float *checkWall(float x0,float y0,float z0,float x1,float y1,float z1);

  void writeTo(FILE *f);
  bool initFrom(FILE *f);

 protected:
  float hei; /* this is the height on the South (or East) end */
  virtual void render0(float hei);
  virtual float height0();
  int angle; // 0: South-North, 1:  East-West
  bool starting; /* if the S (E) end comes out of a "cell" */
  bool ending; /* if the N (W) end goes into a "cell" */

 private:

  float slope;

  //  float t;
  float nrml[3]; // normal vector
  float wnrml[3]; // wall-normal vector
  float tnrml[3]; // transversal wall normal vector
};

#endif
