#include <math.h>

#include "straight.h"
#include "base.h"

Straight::Straight() {}

Straight::~Straight() {}

bool Straight::init(int angle,float slope,float hei) {
  Cell::init();
  this->angle = angle;
  this->slope = slope;
  this->hei = hei;

  /* calculate normal */
  float r = hypotf(1,slope);
  nrml[2*angle] = 0;
  nrml[1] = 1/r;
  nrml[2-2*angle] = -slope/r;

  wnrml[0] = 1-angle;
  wnrml[1] = 0;
  wnrml[2] = angle;

  tnrml[0] = angle;
  tnrml[1] = 0;
  tnrml[2] = 1-angle;

  starting=false;
  ending=false;

  //  t = 0; //debug
  return true;
}

Cell *Straight::clone() {
  Straight *c = new Straight();
  c->init(angle,slope,hei);
  return c;
}

void Straight::putWall(int side,bool wall) {
  if (side==1+angle)
    starting = wall;
  if (side==3-3*angle)
    ending = wall;
}

bool Straight::isConnected(int side) {
  return (angle==0 && (side==1||side==3)) ||
    (angle==1 && (side==0||side==2));
}

float *Straight::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  if (angle==1) {
    float t = x0; x0=z0; z0=t;
    t = x1; x1=z1; z1=t;
  }
  if (x1<0.2f || x1>0.8f) return 0; // endpoint not on track
  /* now endpoint is on track */
  if (x0<0.2f || x0>0.8f) return wnrml; // startpoint not on track
  /* now both end and startpoint on track. Check for transversal
     walls: */
  if (starting) {
//     printf("on starting %f %f\n",x0,z0);
    if (z0<0) return tnrml;
  }
  if (ending) {
//     printf("on ending %f %f\n",x0,z0);
    if (z0>1) return tnrml;
  }
  /* no walls found */
  return normal(x1,y1,z1);
}


void Straight::render0(float hei) {
  //  t +=0.1f; // debug

  float g=0;

  glPushMatrix();
  if (angle==1) {
    glRotatef(90,0,1,0);
    glTranslatef(-1,0,0);
  }

//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();

  /* sides */
  glBegin(GL_QUADS);

  for (int t=0;t<4;t++) {
    g = 1-g; glColor3f(1,g,g);

    /* left */
    glNormal3f(-1,0,0);
    glVertex3f(0.2f,0,t*0.25f);
    glVertex3f(0.2f,0,(t+1)*0.25f);
    glVertex3f(0.2f,hei+slope*((t+1)*0.25f),(t+1)*0.25f);
    glVertex3f(0.2f,hei+slope*(t*0.25f),t*0.25f);

    /* right */
    glNormal3f(1,0,0);
    glVertex3f(0.8f,hei+slope*(t*0.25f),t*0.25f);
    glVertex3f(0.8f,hei+slope*((t+1)*0.25f),(t+1)*0.25f);
    glVertex3f(0.8f,0,(t+1)*0.25f);
    glVertex3f(0.8f,0,t*0.25f);
  }

  if (starting) {
    glNormal3f(0,0,-1);
    glVertex3f(0.8f,0,0);
    glVertex3f(0.2f,0,0);
    glVertex3f(0.2f,hei,0);
    glVertex3f(0.8f,hei,0);
  }
  if (ending) {
    glNormal3f(0,0,1);
    glVertex3f(0.2f,0,1);
    glVertex3f(0.8f,0,1);
    glVertex3f(0.8f,hei+slope,1);
    glVertex3f(0.2f,hei+slope,1);    
  }

  glColor3f(savePoint!=0?0:1,0.9f,0.2f);
  /* top */
  glNormal3fv(nrml);
  glVertex3f(0.8f,hei,      0);
  glVertex3f(0.2f,hei,      0);
  glVertex3f(0.2f,hei+slope/2,0.5f);
  glVertex3f(0.8f,hei+slope/2,0.5f);

  glColor3f(savePoint!=0?0:1,0.8f,0.1f);
  /* top */
  //  glNormal3fv(nrml);
  glVertex3f(0.8f,hei+slope/2,0.5f);
  glVertex3f(0.2f,hei+slope/2,0.5f);
  glVertex3f(0.2f,hei+slope,1);
  glVertex3f(0.8f,hei+slope,1);

  glEnd();

  glPopMatrix();

}

void Straight::render(Theme *theme) {
  render0(hei);
}

float Straight::height0() {
  return hei;
}

float Straight::height(float x,float y,float z) {
  float rx,rz; // "rotated"
  if (angle==1) {rx=z;rz=x;} else {rx=x;rz=z;}

  if (rx<0.2f || rx>0.8f) return 0;

  return height0()+slope*rz;
}

float *Straight::normal(float x,float y,float z) {
  static float v[]={0,1,0};

  if (angle==1) {

    if (z<0.2f || z>0.8f)
      return v;
    else
      return nrml;

  } else {

    if (x<0.2f || x>0.8f)
      return v;
    else
      return nrml;

  } 
}

void Straight::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," l %d %f %f %c%c",angle,hei,slope,starting?'[':'-',ending?']':'-');
}

bool Straight::initFrom(FILE *f) {
  int a;
  float h,s;
  char bs,be;
  int n = fscanf(f," %d %f %f %c%c",&a,&h,&s,&bs,&be);
  if (n<5) {
    printf("found %d items, expected 5\n",n);
    return false;
  }
  if (!init(a,s,h)) return false;
  starting= (bs=='[');
  ending= (be==']');
  return true;
}
