#ifndef SMOOTH_H
#define SMOOTH_H

class Cell;
//#include "cell.h"
#include "car.h"

/* A smooth straight track segment. You give the height and slope both
   at the beginning and the end, and this computes the third order
   polynomial that will satisfy these constraints. */

class Smooth : public Cell {
 public:
  Smooth();
  ~Smooth();

  bool init(int angle,float hei0,float slope0,float hei1,float slope1);
  Cell *clone();
  void putWall(int side,bool wall);
  void setHeight(int side,float h,float s);

  void render(Theme *theme);

  void interact(Car *c,float t);
  float height(float x,float y,float z);
  float *normal(float x,float y,float z);
  bool isConnected(int side);
  float *checkWall(float x0,float y0,float z0,float x1,float y1,float z1);

  void writeTo(FILE *f);
  bool initFrom(FILE *f);

  virtual float height0(float t);
  virtual float *normal0(float t);

 protected:
/*   void renderSides(); */

  /* The height at point t has height at+bt+ct+d */
  float a,b,c,d;

  int angle; // 0: South-North, 1:  East-West

  bool starting; /* if the S (E) end comes out of a "cell" */
  bool ending; /* if the N (W) end goes into a "cell" */

  /* When did a car last interact with this (this is used for visual
     effect on savepoints). */
  float lastInteract;

  float wnrml[3]; // wall-normal vector
  float tnrml[3]; // transversal wall normal vector
};

#endif
