#include <math.h>

#include "cell.h"
#include "smooth.h"

#include "base.h"
#include "main.h"

Smooth::Smooth() {}

Smooth::~Smooth() {}

bool Smooth::init(int angle,float hei0,float slope0,float hei1,float slope1) {
  Cell::init();

  this->angle = angle;

  /* third order curve fitting... */
  a = slope0+slope1-2*(hei1-hei0);
  b = 3*(hei1-hei0)-2*slope0-slope1;
  c = slope0;
  d = hei0;

  wnrml[0] = 1-angle;
  wnrml[1] = 0;
  wnrml[2] = angle;

  tnrml[0] = angle;
  tnrml[1] = 0;
  tnrml[2] = 1-angle;

  starting=false;
  ending=false;

  lastInteract=0;

  //  t = 0; //debug
  return true;
}

Cell *Smooth::clone() {
  Smooth *cel = new Smooth();
  cel->init(angle, d, c, a+b+c+d, 3*a+2*b+c);
  return cel;
}

void Smooth::putWall(int side,bool wall) {
//   printf("smooth %d putting wall %d on %d.\n",angle,wall,side);
  if (side==1+angle)
    starting = wall;
  if (side==3-3*angle)
    ending = wall;
}

void Smooth::setHeight(int side,float h,float s) {
  bool st = this->starting;
  bool en = this->ending;
  int sv = this->savePoint;
  int lst = this->last;
//   printf("side %d:",side);
  if ((angle==0 && side==1) || (angle==1 && side==2)) {
    init(angle,h,s, a+b+c+d, 3*a+2*b+c);
//     printf("left");
  } else if ((angle==0 && side==3) || (angle==1 && side==0)) {
    init(angle, d,c,h,s);
//     printf("right");
  }
//   printf("\n");
  this->starting = st;
  this->ending = en;
  this->savePoint = sv;
  this->last = lst;
}

bool Smooth::isConnected(int side) {
  return (angle==0 && (side==1||side==3)) ||
    (angle==1 && (side==0||side==2));
}

float *Smooth::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  //  printf("checkwall %f %f-%f %f ",x0,z0,x1,z1);
    /* that's "x0 rotated", etc. Not "leet speak". */
  float x0r,z0r,x1r,z1r;
  if (angle==1) {
    x0r = z0;
    z0r = x0;
    x1r = z1;
    z1r = x1;
  } else {
    x0r = x0;
    z0r = z0;
    x1r = x1;
    z1r = z1;
  }

//   printf("{%f-%f}",x0,x1);
  //  printf("~ %f %f-%f %f\n",x0,z0,x1,z1);
  if (x1r<0.2f || x1r>0.8f) {// printf("*->out (ok)");
    return normal(x1,y1,z1); // endpoint not on track
      }
  /* now endpoint is on track */
  if (x0r<0.2f || x0r>0.8f) {// printf("out->in");
    return wnrml;} // startpoint not on track
  /* now both end and startpoint on track. Check for transversal
     walls: */
  if (starting) {
    //    printf("on starting %f %f\n",x0,z0);
    if (z0r<0) {// printf("->[");
      return tnrml;}
  }
  if (ending) {
    //    printf("on ending %f %f\n",x0,z0);
    if (z0r>1) {// printf("]<-");
      return tnrml;}
  }
//   printf("ok");
  /* no walls found, so we probably went through the ground, and normal()
     returns the normal at that point. */
  return normal(x1,y1,z1);
}

void Smooth::render(Theme *theme) {
  //  t +=0.1f; // debug

  // code to paint normals follows... 
//   glBegin(GL_LINES); {
//     glColor3f(1,1,1);
//     float x = 0;
//     float y = 0;
//     float z = 0;
//     if (angle==0) x=0.5f;
//     else z=0.5f;
//     for (int t=0;t<4;t++) {
//       if (angle==0) z=t*0.25f;
//       else x=t*0.25f;
//       float *n = normal(x,y,z);
//       y = height(x,y,z);
//       glVertex3f(x,y,z);
//       glVertex3f(x+n[0],y+n[1],z+n[2]);
//     }    
//   }
//   glEnd();
  

  glPushMatrix();
  if (angle==1) {
    glRotatef(90,0,1,0);
    glTranslatef(-1,0,0);
  }

//   renderSides();

  theme->straight(this,starting,ending,savePoint!=0,now-lastInteract,variant);

  glPopMatrix();
}

void Smooth::interact(Car *c,float t) {
  float p[3];
  float h;
  
  c->getPosition(p);

  p[0] -= floorf(p[0]);
  p[2] -= floorf(p[2]);

  h = height(p[0],0,p[2]);

  if (h==0) return; // car is not on track

  lastInteract = now;

  //  float *n = normal0(0.5f);
  //   printf("angle %d, normal in the middle %f %f %f\n",angle,n[0],n[1],n[2]);
}

// void Smooth::renderSides() {
//   theme->straightSides(a,b,c,d,starting,ending);
// }

float Smooth::height0(float t) {
  float tt = t*t;
  return a*tt*t + b*tt + c*t + d;
}

float *Smooth::normal0(float t) {
  static float nrml[3];
  float slope=3*a*t*t + 2*b*t + c;
  float r = hypotf(1,slope);
  nrml[angle*2] = 0;
  nrml[1] = 1/r;
  nrml[2-angle*2] = -slope/r;
  return nrml;
}

float Smooth::height(float x,float y,float z) {
  float rx,rz; // "rotated"
  if (angle==1) {rx=z;rz=x;} else {rx=x;rz=z;}

  if (rx<0.2f || rx>0.8f) return 0;

  float h = height0(rz);

  /* This is a kludge to make variant 2 be just a thin platform,
     permitting to pass below it. Variant 1 is the tube */
  if (variant==2 && h>y+0.1f) return 0;
  else if (variant==1 && h>y+0.8f) return 0;
  else return h;
}

float *Smooth::normal(float x,float y,float z) {
  static float v[]={0,1,0};
  if (angle==1) {

    if (z<0.2f || z>0.8f)
      return v;
    else
      return normal0(x);
  } else {
    if (x<0.2f || x>0.8f)
      return v;
    else
      return normal0(z);
  } 
}

void Smooth::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," s %d %f %f %f %f %c%c",angle,a,b,c,d,starting?'[':'-',ending?']':'-');
}

bool Smooth::initFrom(FILE *f) {
  int angle;
  float a,b,c,d;
  char bs,be;

  int n = fscanf(f," %d %f %f %f %f %c%c",&angle,&a,&b,&c,&d,&bs,&be);
  if (n<7) {
    printf("found %d items, expected 7\n",n);
    return false;
  }
  if (!init(angle, d, c, a+b+c+d, 3*a+2*b+c)) return false;
  starting= (bs=='[');
  ending= (be==']');
  return true;
}
