#ifndef RECORD_H
#define RECORD_H

class Record;

#include "car.h"

/* Records a sequence of positions of the car. Unlike Trails, this
   records the time and doesn't erase itself, so that it's meant to
   be played in real time */

class Record {
 public:
  Record();
  ~Record();

  bool init();

  /* Prepares for a new recording session */
  void reset();

  /* Record that the car was at that position and angle at that
     time. The time should be strictly increasing from call to call */
  void record(float *pos,float angle,float tilt,int time);

  /** Puts the car at the position at which it was recorded for the
      given time. *Constant* interpolation is done as follows:

      1) t0 being the earliest recorded time, the car is assumed to
      have been frozen at that position until t0.

      2) t and t' being any two consecutively recorded points, the car
      is assumed to have been frozen at the position it was at time t
      in the interval [t ; t'[.

      3) tn being the last recorded time, the car is assumed to no
      longer move after that time.

      This call is fast if querying points close to each other
      (forward or backward) in time, but is slow if you make a large
      jump in time. */
  void putCar(Car *car,int time);


 private:
  /* How many slots have been allocated */
  int len;
  /* Index for the next slot to be used */
  int next;
  /* Index of the latest position found by putCat(). This is based on
     the assumption that sequential putCat() calls will refer to
     points close to each other */
  int focus;

  /* Each of the following arrays contain len entries */
  float *x;
  float *y;
  float *z;
  float *angle;
  float *tilt;
  int *time;
};

#endif
