#include "base.h"

#include "record.h"

Record::Record() {}
Record::~Record() {
  delete x;
  delete y;
  delete z;
  delete angle;
  delete tilt;
  delete time;
}

bool Record::init() {
  len = 10000;
  next = 0;
  focus = 0;
  x = new float[len];
  y = new float[len];
  z = new float[len];
  angle = new float[len];
  tilt = new float[len];
  time = new int[len];
  return true;
}

void Record::reset() {
  next = 0;
  focus = 0;
}

void Record::record(float *pos,float angle,float tilt,int time) {
  if (next<len) {
    //    printf("recording %d\n",next);
    this->x[next] = pos[0];
    this->y[next] = pos[1];
    this->z[next] = pos[2];
    this->angle[next] = angle;
    this->tilt[next] = tilt;
    this->time[next] = time;
    next++;
  } else {
    //    printf("record full!");
    /* Should allocate bigger arrays. Will do that some other day :) */
  }
}

void Record::putCar(Car *car,int t) {
  float p[3];
  /* First move forwards until we're strictly later than t */
  while (focus<(next-1) && time[focus] <= t) focus++;
  /* Then move backwards until we're at t or before */
  while (focus>0    && time[focus]  > t) focus--;
  /* Now we can put the car. I REALLY need to make up my mind between
     those [x,y,z] and arrays. */
  //  printf("reading %d (%d,%d,%d)\n",focus,time[focus],t,time[focus+1]);
  if (focus==next-1) {
    p[0]=x[focus]; p[1]=y[focus]; p[2]=z[focus];
    car->put(p,angle[focus],tilt[focus]);
  } else {
    /* do some linear interpolation for prettiness */
    float k = ((float)(t-time[focus]))/(time[focus+1]-time[focus]);
    p[0]=x[focus]*(1-k) + x[focus+1]*k;
    p[1]=y[focus]*(1-k) + y[focus+1]*k;
    p[2]=z[focus]*(1-k) + z[focus+1]*k;
    car->put(p,angle[focus]*(1-k)+angle[focus+1]*k,tilt[focus]*(1-k)+tilt[focus+1]*k);

  }
}
