#ifndef MULTICELL_H
#define MULTICELL_H

class Multicell;

#include <stdio.h>
#include "car.h"
#include "cell.h"


/* Piles more than one cell into one. For cross roads and tracks
   passing over each other. Don't put save points on multicells. **/
class Multicell : public Cell {
 public:
  Multicell();
  ~Multicell();

  /** Create a blank multicell, that is like cell() but doesn't even
      render anything */
  bool init();

  /** Insert the given cell at the "top" of the stack. Note that the
      order is mostly irrelevant, but convention is to start from
      bottom and go up. Note that the object is not cloned, so leave
      it on the heap. It will then get freed when it "leaves" this
      object (see next method) or when the multicell itself is
      freed. **/
  void addCell(Cell *c);

  /** Remove the cell at the top, if any, and free any associated
      memory. */
  void pullCell();

  void putWall(int side,bool wall);

  void setHeight(int side,float h,float s);
  
  /* Should I somehow replace this? Management of connected objects
     is not very trivial any more.. */
  /*  void setCoordinates(int x,int z); */
  
  /* This is deep copying */
  Multicell *clone();

  void render(Theme *theme);

  bool isConnected(int side);

  float *normal(float x,float y,float z);

  float height(float x,float y,float z);

  float *checkWall(float x0,float y0,float z0,float x1,float y1,float z1);

  void interact(Car *c,float t);

  /* the lowest cell that answers wins. A better way would be to have
     the one whose reply to height() is largest, but then we need an
     y coordinate. */
  bool preferredAngle(float *angle);

  void writeTo(FILE *f);

/* Multicells don't have a character "signature". Instead, Track::load
   dynamically decides to make a multicell when seeing semi-colons in
   a row. That also means there's no need for a MultiCell::initFrom */
//  bool initFrom(FILE *f);

 private:
  /* We use a growing array for storing the stack. capacity is the
     allocated array space and cnt is the actual object count. */
  Cell **stack;
  int capacity;
  int cnt;

  /** Return the cell in the stack that is the nearest of the given
      point, or null in case the stack is empty. That's for functions
      which should really affect one object at a time, like normal()
      or setHeight(). */
  Cell *nearest(float x,float y,float z);
};

#endif
