
#include <math.h>
#include <string.h>
#include "multicell.h"

Multicell::Multicell() {}
Multicell::~Multicell() {
  for (int i=0;i<cnt;i++)
    delete stack[i];

  delete stack;
}

bool Multicell::init() {
  capacity=2; // most common reason to use a multicell
  stack=new Cell *[capacity];
  cnt=0;
  return true;
}

void Multicell::addCell(Cell *c) {
  if (cnt>=capacity) {
    capacity = cnt+1;
    Cell **st2 = new Cell *[capacity];
    memcpy(st2,stack,(sizeof (Cell*))*cnt);
    delete stack;
    stack = st2;
  }
  stack[cnt] = c;
  cnt++;
}

void Multicell::pullCell() {
  if (cnt>0) {
    cnt--;
    delete stack[cnt];
  }
}

void Multicell::putWall(int side,bool wall) {
  for (int i=0;i<cnt;i++) {
    stack[i]->putWall(side,wall);
  }
}

void Multicell::setHeight(int side,float h,float s) {
  if (cnt==0) return;
  nearest(0.5f,h,0.5f)->setHeight(side,h,s);
}

/*  void Multicell::setCoordinates(int x,int z) {} */
  
Multicell *Multicell::clone() {
  Multicell *r = new Multicell();
  r->init();
  for (int i=0;i<cnt;i++) {
    r->addCell(stack[i]->clone());
  }
  return r;
}

void Multicell::render(Theme *theme) {
  for (int i=0;i<cnt;i++) {
    stack[i]->render(theme);
  }
}

bool Multicell::isConnected(int side) {
  for (int i=0;i<cnt;i++)
    if (stack[i]->isConnected(side))
      return true;

  return false;
}

float *Multicell::normal(float x,float y,float z) {
  if (cnt==0)
    return Cell::normal(x,y,z); // use default behaviour when stack is empty
  else
    return nearest(x,y,z)->normal(x,y,z);
}

float Multicell::height(float x,float y,float z) {
  /* can't use nearest() over here (actually we could, but never mind)
     because nearest is based on height(). So we currently return the
     one that gives the highest value. To be absolutely perfect, we
     should loop through the stack, replacing y by the highest
     returned value, until it stabilises, to take into accout objects
     that may intersect each other. */
  
  float h=0;
  
  for (int i=0;i<cnt;i++)
    h = fmaxf(h, stack[i]->height(x,y,z));

  return h;
}

float *Multicell::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  for (int i=0;i<cnt;i++) {
    if (stack[i]->height(x1,y1,z1)>y1) {
      float *n = stack[i]->checkWall(x0,y0,z0,x1,y1,z1);
      if (n != 0) return n;
    }
  }
  return Cell::checkWall(x0,y0,z0,x1,y1,z1);
}

void Multicell::interact(Car *c,float t) {
  for (int i=0;i<cnt;i++)
    stack[i]->interact(c,t);
}

bool Multicell::preferredAngle(float *angle) {
  for (int i=0;i<cnt;i++)
    if (stack[i]->preferredAngle(angle))
      return true;

  return false;
}

void Multicell::writeTo(FILE *f) {
  if (cnt==0)
    Cell::writeTo(f);
  else for (int i=0;i<cnt;i++) {
      if (i>0) fprintf(f,";");
      stack[i]->writeTo(f);
    }
}

Cell *Multicell::nearest(float x,float y,float z) {
  float maxh=0;
  Cell *r = 0;
  
  for (int i=0;i<cnt;i++) {
    float h = stack[i]->height(x,y,z);
    if (h>maxh || r==0) { // make sure to never return null
      maxh=h;
      r = stack[i];
    }
  }

  return r;
}
