#ifndef METAL_H
#define METAL_H

#include "theme.h"
#include "base.h"

class Metal : public Theme {
 public:
  Metal();
  ~Metal();

  bool init();
  int number();
  void cell(int variant);
  void straightSides(Smooth *s,bool starting,bool ending,int variant);
  void straight(Smooth *s,bool starting,bool ending,bool startPoint,float interactAge,int variant);
  void curve(float h,int variant);
  void fan(Smooth *s,bool starting,bool ending,float angle,int variant);
  void wheel(Smooth *s,bool starting,bool ending,float angle,int variant);

 private:
  /* the rusty thing around the tube */
  GLuint metal_tex;
  /* the grid on which the car rides */
  GLuint grid_tex;
};

#endif
