#include <math.h>

#include "metal.h"

#include "base.h"
#include "cell.h"
#include "smooth.h"

/* for straight */
#define ISMOOTHNESS 10
#define SSMOOTHNESS 10.0f

/* for curve */
#define CSMOOTHNESS 15
#define TOOCSMOOTH (2*CSMOOTHNESS)

/* for wheel */
/* cos(pi/5)/2 */
#define WHEELX 0.9510565162951535312
/* sin(pi/5)/2 */
#define WHEELY 0.3090169943749473958

/* zooming factor for the grid texture */
#define GRIDRATIO 3

Metal::Metal() {
}

Metal::~Metal() {}

bool Metal::init() {
  if (!loadTexture("textures/metal.jpeg",&metal_tex)) {
    printf("loading metal texture failed\n");
    return false;
  } else {
    loadTexture_png("textures/chainlink.png",&grid_tex);
    return true;
  }
}

int Metal::number() {
  return 1;
}

void Metal::cell(int variant) {
  return;
//     glEnable( GL_TEXTURE_2D );
//     glBindTexture(GL_TEXTURE_2D, metal_tex);

//     // Dois tre rappel  chaque fois !! Sinon a prend le env_mode 
//     // du dernier appel
//     glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );  

//     glColor3f(1,1,1);
	glBegin(GL_QUADS);

	glTexCoord2f(1,0);
	glVertex3f(1,0,0);

	glTexCoord2f(0,0);
	glVertex3f(0,0,0);

	glTexCoord2f(0,1);
	glVertex3f(0,0,1);

	glTexCoord2f(1,1);
	glVertex3f(1,0,1);
	glEnd();

//     glDisable(GL_TEXTURE_2D);
}

void Metal::straightSides(Smooth *s,bool starting,bool ending,int variant) {
  float g=0.45f;

  if (variant==1) { // tube
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, metal_tex);
	
    if (starting || ending) {
      glPushMatrix();
      /* go into the ground */
      if (starting) {
	glTranslatef(0.5f,0,0.5f);
	glRotatef(180,0,1,0);
	glTranslatef(-0.5f,0,-0.5f);
      }
      float hei = s->height0(ending?0:1)-1;
      for (int t=0;t<CSMOOTHNESS;t++) {
	float c1 = cosf(t*HALFPI/CSMOOTHNESS);
	float s1 = sinf(t*HALFPI/CSMOOTHNESS);
	float c2 = cosf((t+1)*HALFPI/CSMOOTHNESS);
	float s2 = sinf((t+1)*HALFPI/CSMOOTHNESS);
	glBegin(GL_QUAD_STRIP);
	for (int a=0;a<=10;a++) {
	  float r = sinf(a*TWOPI/10)*0.4f+0.5f;

	  glNormal3f(cosf(a*TWOPI/10),c2*sinf(a*TWOPI/10),s2*sinf(a*TWOPI/10));
	  glTexCoord2f(a/20.0f,(t+1)/SSMOOTHNESS);
	  glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,hei+c2*r,s2*r);
	  glNormal3f(cosf(a*TWOPI/10),c1*sinf(a*TWOPI/10),s1*sinf(a*TWOPI/10));
	  glTexCoord2f(a/20.0f,t/SSMOOTHNESS);
	  glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,hei+c1*r,s1*r);
	}
	glEnd();
      }
      glBegin(GL_QUAD_STRIP);
      for (int a=0;a<=10;a++) {
	glTexCoord2f(a/20.0f,1-hei);
	glNormal3f(cosf(a*TWOPI/10),0,sinf(a*TWOPI/10));
	glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,0,0.5f+sinf(a*TWOPI/10)*0.4f);

	glTexCoord2f(a/20.0f,1);
	glNormal3f(cosf(a*TWOPI/10),0,sinf(a*TWOPI/10));
	glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,hei,0.5f+sinf(a*TWOPI/10)*0.4f);
      }
      glEnd();
      glPopMatrix();
    } else {
      for (int t=0;t<ISMOOTHNESS;t++) {
	float y0=s->height0(t/SSMOOTHNESS)-0.5f;
	float y1=s->height0((t+1)/SSMOOTHNESS)-0.5f;
	glBegin(GL_QUAD_STRIP);
	for (int a=0;a<=10;a++) {
	  /* normal is not quite right but it's a start */
	  glNormal3f(cosf(a*TWOPI/10),sinf(a*TWOPI/10),0);
	  glTexCoord2f(a/20.0f,(t+1)/SSMOOTHNESS);
	  glVertex3f(cosf(a*TWOPI/10)*0.4f+0.5f,y1+sinf(a*TWOPI/10)*0.4f,(t+1)/SSMOOTHNESS);
	  glTexCoord2f(a/20.0f,t/SSMOOTHNESS);
	  glVertex3f(cosf(a*TWOPI/10)*0.4f+0.5f,y0+sinf(a*TWOPI/10)*0.4f,t/SSMOOTHNESS);
	}
	glEnd();
      }
    }
    glDisable(GL_TEXTURE_2D);
  } else if (variant==0) { // shiny

    //    glPushMatrix();
    //   if (angle==1) {
    //     glRotatef(90,0,1,0);
    //     glTranslatef(-1,0,0);
    //   }

    glBegin(GL_QUADS);

    for (int t=0;t<ISMOOTHNESS;t++) {
      if (t==ISMOOTHNESS/2) g = 1-g;
      glColor3f(g,g,0.5f);

      /* left */
      glNormal3f(-1,0,0);
      glVertex3f(0.2f,0,t/SSMOOTHNESS);
      glVertex3f(0.2f,0,(t+1)/SSMOOTHNESS);
      glVertex3f(0.2f,s->height0((t+1)/SSMOOTHNESS),(t+1)/SSMOOTHNESS);
      glVertex3f(0.2f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);

      /* right */
      glNormal3f(1,0,0);
      glVertex3f(0.8f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);
      glVertex3f(0.8f,s->height0((t+1)/SSMOOTHNESS),(t+1)/SSMOOTHNESS);
      glVertex3f(0.8f,0,(t+1)/SSMOOTHNESS);
      glVertex3f(0.8f,0,t/SSMOOTHNESS);
    }

    glColor3f(0.5f,0.5f,0.5f);

    if (starting) {
      glNormal3f(0,0,-1);
      glVertex3f(0.8f,0,0);
      glVertex3f(0.2f,0,0);
      glVertex3f(0.2f,s->height0(0),0);
      glVertex3f(0.8f,s->height0(0),0);
    }
    if (ending) {
      glNormal3f(0,0,1);
      glVertex3f(0.2f,0,1);
      glVertex3f(0.8f,0,1);
      glVertex3f(0.8f,s->height0(1),1);
      glVertex3f(0.2f,s->height0(1),1);
    }

    glEnd();



    /** DEBUG: render a line 0.7 units above the track, for checking
	camera behaviour */
    //   glBegin(GL_LINE_STRIP);
    //   glColor3f(1,1,1);
    //   for (int t=0;t<=ISMOOTHNESS;t++) {
    //     glVertex3f(0.5f,s->height0(t/SSMOOTHNESS)+0.7f,t/SSMOOTHNESS);
    //   }
    //   glEnd();
    /* debugging ends here */

    //    glPopMatrix();

  }
}

void Metal::straight(Smooth *s,bool starting,bool ending,bool savePoint,float interactAge,int variant) {

//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();

  /* sides */

  /* Note that this is meant to come *after* the "straightSides" for
     variant 0 */
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blueshine);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  glColor3f(0.7f,0.6f,0.6f);
  if (variant!=2) // 2 has just the top
    straightSides(s,starting,ending,variant);

  if (variant==1 || variant==2) {
    /* Put a grid on top of the tube */
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_CULL_FACE);

    glBindTexture(GL_TEXTURE_2D, grid_tex);
    //    glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
    glBegin(GL_QUADS);
    glColor4f(1,1,1,1);

    for (int t=0;t<ISMOOTHNESS;t++) {
      /* top */
      glNormal3fv(s->normal0(t/SSMOOTHNESS));
      glTexCoord2f(GRIDRATIO,GRIDRATIO*t/SSMOOTHNESS);
      glVertex3f(0.8f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);

      glTexCoord2f(0,GRIDRATIO*t/SSMOOTHNESS);
      glVertex3f(0.2f,s->height0(t/SSMOOTHNESS),t/SSMOOTHNESS);

      glNormal3fv(s->normal0((t+1)/SSMOOTHNESS));
      glTexCoord2f(0,GRIDRATIO*(t+1)/SSMOOTHNESS);
      glVertex3f(0.2f,s->height0((t+1)/SSMOOTHNESS),((t+1)/SSMOOTHNESS));

      glTexCoord2f(GRIDRATIO,GRIDRATIO*(t+1)/SSMOOTHNESS);
      glVertex3f(0.8f,s->height0((t+1)/SSMOOTHNESS),((t+1)/SSMOOTHNESS));
    }

    glEnd();
    //    glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );
    glEnable(GL_CULL_FACE);
    glDisable(GL_TEXTURE_2D);

  } else if (variant==0) {

    glBegin(GL_QUAD_STRIP);

    glColor3f(0.7f,0.6f,0.6f);
    for (int t=0;t<=ISMOOTHNESS;t++) {
      //     if (savePoint && t>0.1f*ISMOOTHNESS && t< 0.9f*ISMOOTHNESS)
      //       glColor3f(1,0,0);
      //     else
      //       glColor3f(0.7f,0.6f,0.6f);
      glNormal3fv(s->normal0(0.05f+0.9f*t/SSMOOTHNESS));
      glVertex3f(0.8f,s->height0(0.05f+0.9f*t/SSMOOTHNESS),0.05f+0.9f*t/SSMOOTHNESS);
      glVertex3f(0.2f,s->height0(0.05f+0.9f*t/SSMOOTHNESS),0.05f+0.9f*t/SSMOOTHNESS);
      //     glNormal3fv(s->normal0(0.05f+0.9f*(t+1)/SSMOOTHNESS));
      //     glVertex3f(0.2f,s->height0(0.05f+0.9f*(t+1)/SSMOOTHNESS),(0.05f+0.9f*(t+1)/SSMOOTHNESS));
      //     glVertex3f(0.8f,s->height0(0.05f+0.9f*(t+1)/SSMOOTHNESS),(0.05f+0.9f*(t+1)/SSMOOTHNESS));

    }

    glEnd();

    glBegin(GL_QUADS);

    /* starting bit */
    float h0 = s->height0(0)-0.01f;
    float h1 = s->height0(0.05f);
    float l = hypot(0.05f,h1-h0);

    glNormal3f(0,0.05f/l,(h0-h1)/l);
    glVertex3f(0.8f,h0,0);
    glVertex3f(0.2f,h0,0);
    glVertex3f(0.2f,h1,0.05f);
    glVertex3f(0.8f,h1,0.05f);

    /* ending bit */
    h0 = s->height0(0.95f);
    h1 = s->height0(1)-0.01f;
    l = hypot(0.05f,h1-h0);

    glNormal3f(0,0.05f/l,(h0-h1)/l);
    glVertex3f(0.8f,h0,0.95f);
    glVertex3f(0.2f,h0,0.95f);
    glVertex3f(0.2f,h1,1);
    glVertex3f(0.8f,h1,1);

    glEnd();
  }
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  if (savePoint) {
    glBegin(GL_QUADS);
    glColor3f(interactAge<1000?1-interactAge/1000:0,0,0);
    glVertex3f(0.22f,s->height0(0.22f)+0.005f,0.22f);
    glVertex3f(0.22f,s->height0(0.78f)+0.005f,0.78f);
    glVertex3f(0.78f,s->height0(0.78f)+0.005f,0.78f);
    glVertex3f(0.78f,s->height0(0.22f)+0.005f,0.22f);
    glEnd();
  }
}

void Metal::curve(float hei,int variant) {
   float g=0.45f;

//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();

   if (variant==1) { // tube
     glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blueshine);
     glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
     glEnable(GL_TEXTURE_2D);
     glBindTexture(GL_TEXTURE_2D, metal_tex);

     glColor3f(0.7f,0.6f,0.6f);

     for (int t=0;t<CSMOOTHNESS;t++) {
       float c1 = cosf(t*HALFPI/CSMOOTHNESS);
       float s1 = sinf(t*HALFPI/CSMOOTHNESS);
       float c2 = cosf((t+1)*HALFPI/CSMOOTHNESS);
       float s2 = sinf((t+1)*HALFPI/CSMOOTHNESS);
       glBegin(GL_QUAD_STRIP);
       for (int a=0;a<=10;a++) {
	 float r = cosf(a*TWOPI/10)*0.4f+0.5f;
	 glTexCoord2f(a/20.0f,(t+1)/SSMOOTHNESS);
	 glNormal3f(c2*cosf(a*TWOPI/10),sinf(a*TWOPI/10),s2*cosf(a*TWOPI/10));
	 glVertex3f(c2*r,hei-0.5f+sinf(a*TWOPI/10)*0.4f,s2*r);
	 glTexCoord2f(a/20.0f,t/SSMOOTHNESS);
	 glNormal3f(c1*cosf(a*TWOPI/10),sinf(a*TWOPI/10),s1*cosf(a*TWOPI/10));
	 glVertex3f(c1*r,hei-0.5f+sinf(a*TWOPI/10)*0.4f,s1*r);
       }
       glEnd();
     }
     /* now the grid on top */
     glBindTexture(GL_TEXTURE_2D, grid_tex);
     glDisable(GL_CULL_FACE);

     glBegin(GL_QUADS);
     for (int i=0;i<CSMOOTHNESS;i++) {
       glNormal3f(0,1,0);
       glTexCoord2f(GRIDRATIO*cosf(i*(PI/TOOCSMOOTH))*0.8f,GRIDRATIO*sinf(i*(PI/TOOCSMOOTH))*0.8f);
       glVertex3f(cosf(i*(PI/TOOCSMOOTH))*0.8f,hei,sinf(i*(PI/TOOCSMOOTH))*0.8f);

       glTexCoord2f(GRIDRATIO*cosf(i*(PI/TOOCSMOOTH))*0.2f,GRIDRATIO*sinf(i*(PI/TOOCSMOOTH))*0.2f);
       glVertex3f(cosf(i*(PI/TOOCSMOOTH))*0.2f,hei,sinf(i*(PI/TOOCSMOOTH))*0.2f);

       glTexCoord2f(GRIDRATIO*cosf((i+1)*(PI/TOOCSMOOTH))*0.2f,GRIDRATIO*sinf((i+1)*(PI/TOOCSMOOTH))*0.2f);
       glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.2f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.2f);

       glTexCoord2f(GRIDRATIO*cosf((i+1)*(PI/TOOCSMOOTH))*0.8f,GRIDRATIO*sinf((i+1)*(PI/TOOCSMOOTH))*0.8f);
       glVertex3f(cosf((i+1)*(PI/TOOCSMOOTH))*0.8f,hei,sinf((i+1)*(PI/TOOCSMOOTH))*0.8f);
     }
     glEnd();

     glEnable(GL_CULL_FACE);
     glDisable(GL_TEXTURE_2D);
   } else if (variant==0) { // shiny

     /* sides */
     glBegin(GL_QUADS);

     for (int i=0;i<CSMOOTHNESS;i++) {
       if (i%3==0) g = 1-g;

       glColor3f(g,g,0.5f);

       /* left */
       glNormal3f(-cosf(i*(PI/TOOCSMOOTH)),0,-sinf(i*(PI/TOOCSMOOTH)));
       glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.15f,hei,0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.15f);
       glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.15f,0,  0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.15f);
       glNormal3f(-cosf((i+1)*(PI/TOOCSMOOTH)),0,-sinf((i+1)*(PI/TOOCSMOOTH)));
       glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.15f,0,  0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.15f);
       glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.15f,hei,0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.15f);

       /* right */
       glNormal3f(cosf(i*(PI/TOOCSMOOTH)),0,sinf(i*(PI/TOOCSMOOTH)));
       glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.75f,0,  0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.75f);
       glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.75f,hei,0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.75f);
       glNormal3f(cosf((i+1)*(PI/TOOCSMOOTH)),0,sinf((i+1)*(PI/TOOCSMOOTH)));
       glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.75f,hei,0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.75f);
       glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.75f,0,  0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.75f);
       // }

       //   if (starting) {
       //     glNormal3f(0,0,-1);
       //     glVertex3f(0.2f,0,0);
       //     glVertex3f(0.8f,0,0);
       //     glVertex3f(0.8f,hei,0);
       //     glVertex3f(0.2f,hei,0);
       //   }
       //   if (ending) {
       //     glNormal3f(0,0,1);
       //     glVertex3f(0.2f,0,1);
       //     glVertex3f(0.2f,hei+slope,1);    
       //     glVertex3f(0.8f,hei+slope,1);
       //     glVertex3f(0.8f,0,1);
       //   }

     }

     /* starting and ending vertical bits */
     glNormal3f(-1,0,0);
     glVertex3f(0.2f,0,0);
     glVertex3f(0.2f,0,0.05f);
     glVertex3f(0.2f,hei,0.05f);
     glVertex3f(0.2f,hei,0);

     glNormal3f(1,0,0);
     glVertex3f(0.8f,0,0);
     glVertex3f(0.8f,hei,0);
     glVertex3f(0.8f,hei,0.05f);
     glVertex3f(0.8f,0,0.05f);

     glNormal3f(0,0,-1);
     glVertex3f(0,0,0.2f);
     glVertex3f(0,hei,0.2f);
     glVertex3f(0.05f,hei,0.2f);
     glVertex3f(0.05f,0,0.2f);

     glNormal3f(0,0,1);
     glVertex3f(0,0,0.8f);
     glVertex3f(0.05f,0,0.8f);
     glVertex3f(0.05f,hei,0.8f);
     glVertex3f(0,hei,0.8f);

     glEnd();


     /* top */

     glColor3f(0.7f,0.6f,0.6f);
     glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blueshine);
     glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
     glBegin(GL_QUADS);
     glNormal3f(0,1,0);

     for (int i=0;i<CSMOOTHNESS;i++) {
       glVertex3f(0.05f+cosf(PI*i/TOOCSMOOTH)*0.75f,hei,0.05f+sinf(PI*i/TOOCSMOOTH)*0.75f);
       glVertex3f(0.05f+cosf(PI*i/TOOCSMOOTH)*0.15f,hei,0.05f+sinf(PI*i/TOOCSMOOTH)*0.15f);
       glVertex3f(0.05f+cosf(PI*(i+1)/TOOCSMOOTH)*0.15f,hei,0.05f+sinf(PI*(i+1)/TOOCSMOOTH)*0.15f);
       glVertex3f(0.05f+cosf(PI*(i+1)/TOOCSMOOTH)*0.75f,hei,0.05f+sinf(PI*(i+1)/TOOCSMOOTH)*0.75f);
     }
     glEnd();

     glBegin(GL_QUADS);
     /* starting bit */
     float h0 = hei-0.01f;
     float h1 = hei;
     float l = hypot(0.05f,h1-h0);

     glNormal3f(0,0.05f/l,(h0-h1)/l);
     glVertex3f(0.8f,h0,0);
     glVertex3f(0.2f,h0,0);
     glVertex3f(0.2f,h1,0.05f);
     glVertex3f(0.8f,h1,0.05f);

     /* ending bit */
     //   h0 = s->height0(0.95f);
     //   h1 = s->height0(1)-0.01f;
     //   l = hypot(0.05f,h1-h0);

     glNormal3f((h0-h1)/l,0.05f/l,0);
     glVertex3f(0.05f,h1,0.8f);
     glVertex3f(0.05f,h1,0.2f);
     glVertex3f(0,h0,0.2f);
     glVertex3f(0,h0,0.8f);
     glEnd();
   }
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
}
  /* angle is the fan angle, not the road angle */
void Metal::fan(Smooth *s,bool starting,bool ending,float angle,int variant) {
  glPushMatrix();
  if (variant==1) { // tube
    glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blueshine);
    glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
    glColor3f(0.7f,0.6f,0.6f);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, metal_tex);
    glDisable(GL_CULL_FACE);

    if (starting) {
      glTranslatef(0.5f,0,0.5f);
      glRotatef(180,0,1,0);
      glTranslatef(-0.5f,0,-0.5f);
    }
    float hei = s->height0(ending?0:1);
    for (int t=0;t<CSMOOTHNESS;t++) {
      float c1 = cosf(t*HALFPI/CSMOOTHNESS);
      float s1 = sinf(t*HALFPI/CSMOOTHNESS);
      float c2 = cosf((t+1)*HALFPI/CSMOOTHNESS);
      float s2 = sinf((t+1)*HALFPI/CSMOOTHNESS);
      glBegin(GL_QUAD_STRIP);
      for (int a=0;a<=10;a++) {
	float r = sinf(a*TWOPI/10)*0.4f+0.5f;
	glTexCoord2f(a/20.0f,t/SSMOOTHNESS);
	glNormal3f(cosf(a*TWOPI/10),-c1*sinf(a*TWOPI/10),s1*sinf(a*TWOPI/10));
	glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,hei-c1*r,s1*r);

	glTexCoord2f(a/20.0f,(t+1)/SSMOOTHNESS);
	glNormal3f(cosf(a*TWOPI/10),-c2*sinf(a*TWOPI/10),s2*sinf(a*TWOPI/10));
	glVertex3f(0.5f+cosf(a*TWOPI/10)*0.4f,hei-c2*r,s2*r);
      }
      glEnd();
    }
    glEnable(GL_CULL_FACE);
    glDisable(GL_TEXTURE_2D);
  } else {
    straightSides(s,starting,ending,variant);
  }
  glTranslatef(0.5f,s->height0(0.5f),0.5f);
  glRotatef(angle,0,1,0);
  glColor3f(0.1f,0.3f,0.7f);
  glDisable(GL_CULL_FACE);
  for (int i=0;i<3;i++) {
    glBegin(GL_TRIANGLES);
    glVertex3f(0,0,0);
    glVertex3f(0.4f,0,0);
    glVertex3f(0.3f,-0.2f,0.2f);
    glEnd();
    glRotatef(120,0,1,0);
  }
  glEnable(GL_CULL_FACE);
  glPopMatrix();
  
}
  /* angle is the wheel angle, not the road angle */
void Metal::wheel(Smooth *s,bool starting,bool ending,float angle,int variant) {
  straight(s,starting,ending,false,10000,variant);

  float f = 0.5f;

  /* debug display starts */
//   glColor3f(1,0,0);
//   glBegin(GL_LINES);
//   for (int i=0;i<40;i++) {
//     glVertex3f(i/40.0f,0.7f,0.29f);
//     glVertex3f(i/40.0f,height(i/40.0f,0.7f,0.5f),0.29f);
//   }
//   glEnd();
  /* debug display ends */

  glTranslatef(0.5f,s->height0(0.5f)+0.4f,0);

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,blueshine);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  glColor3f(0.7f,0.7f,0.7f);
  glRotatef(angle,0,0,1);
  for (int i=0;i<20;i++) {
    if (i%2==0) {
      /* "tooth" side */
      glBegin(GL_QUADS);
      glNormal3f(0,1,0);
      glVertex3f(0,-f,0.7f);
      glVertex3f(0,-f,0.3f);
      
      f = 0.8f-f;
//       f = 0.5f-f;

      glVertex3f(0,-f,0.3f);
      glVertex3f(0,-f,0.7f);
      glEnd();
    }
    glNormal3f(0,0,-1);
    glBegin(GL_TRIANGLES);
    /* front */
    glVertex3f(0,-0,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(0,-f,0.3f);

    /* back */
    glVertex3f(0,-0,0.7f);
    glVertex3f(0,-f,0.7f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();

    /* side */
    glBegin(GL_QUADS);
    glNormal3f(1,0,0);
    glVertex3f(0,-f,0.7f);
    glVertex3f(0,-f,0.3f);

    glNormal3f(WHEELX,WHEELY,0);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();
    glRotatef(18,0,0,1);
  }

  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,0);
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
}

//void Metal::bouncing() {}
