//#include "ball.h"
#include <math.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

#include "main.h"

/* portability note: this only works on linux and bsd systems */

void reload(char **entries,int current) {
  char fname[132];
  sprintf(fname,"maps/%s",entries[current]);
  track.load(fname);
}

void menu() {

  int next = 0;
  int capacity = 10; // how big entries is.
  /* store the file names in here */
  char **entries = new char *[10];
  int current = 0;

  /** There's probably a standard library for that.. oh well */
  DIR *d = opendir("maps");
  if (d) {
    dirent *e;
    while ((e=readdir(d))) {
      if (e->d_type==DT_REG) {
	if ((next >= capacity)) {
	  char **entries2 = new char *[capacity+10];
	  memcpy(entries2, entries, (sizeof (char*))*capacity);
	  free(entries);
	  entries = entries2;
	  capacity += 10;
	}
	entries[next] = new char[128];
	strncpy(entries[next],e->d_name,128);
	next++;
      }
    }
    closedir(d);
  }

//    for (int i=0;i<next;i++) {
//      printf("%s\n",entries[i]);
//    }


   bool done=false;
   SDL_Event event;

   glMatrixMode(GL_PROJECTION);                        // Select The Projection Matrix
   glLoadIdentity();                                   // Reset The Projection Matrix
   glPerspective( 45.0f, (GLfloat)SCREEN_WIDTH/(GLfloat)SCREEN_HEIGHT, 1.0f, 10000.0f );
   glMatrixMode(GL_MODELVIEW);
   glViewport(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

   while (!done) {

    now=SDL_GetTicks(); // for animated objects to display properly

    SDL_WaitEvent(0);

    while( SDL_PollEvent(& event) )
      {
	switch ( event.type ) {
	case SDL_QUIT :
	  done=true;
	  break;
	case SDL_KEYDOWN :           
	  switch (event.key.keysym.sym) {
	  case SDLK_q:
	  case SDLK_ESCAPE:
	    done=true;
	    break;
	  case SDLK_DOWN:
	    current++;
	    if (current >= next) current = 0;
	    reload(entries,current);
	    break;
	  case SDLK_UP:
	    current--;
	    if (current<0) current = next-1;
	    reload(entries,current);
	    break;
	  default: break;
	  }
	  break;
	default: break;
	}
      }

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer
    
    glLoadIdentity();

    glPushMatrix();
    glRotatef(30,1,0,0);
    glTranslatef(0.9f,-1,-2);
    glRotatef(now/20.0f,0,1,0);
    glTranslatef(-0.5f,0,-0.5f);
    float z = fmaxf(track.getWid(),track.getLen());
    glScalef(1/z,1/z,1/z);
    track.render();
    glPopMatrix();

    glEnable( GL_TEXTURE_2D );
    glBindTexture(GL_TEXTURE_2D, tex_id);

    // Dois tre rappel  chaque fois !! Sinon a prend le env_mode 
    // du dernier appel
    //    glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );  

    glColor3f(1,1,1);
    glTranslatef(-0.7f,0.4f,-1);
    glScalef(0.07f,0.07f,0.07f);
    for (int i=0;i<next;i++) {
      glPushMatrix();
      char *c = entries[i];
      int n;
      while (*c !=0) {
	if (*c>='a' && *c <= 'z') {
	  n = *c - 'a';
	} else if (*c>='A' && *c <= 'Z') {
	  n = *c - 'A';
	} else if (*c>='0' && *c <= '9') {
	  n = *c + 26-'0';
	} else {
	  n = 36;
	}
	glBegin(GL_QUADS);
	/* every block in the "alphabet" texture is 13 pixel wide, and
	   the entire texture is 512 pixels wide */
	static const float rh = 13/512.0f;
	static const float rv = 13/16.0f;
	glTexCoord2f((n+1)*rh,0);
	glVertex3f(1,-i*1.5f,  0);

	glTexCoord2f(n*rh,0);
	glVertex3f(0,-i*1.5f,  0);

	glTexCoord2f(n*rh,rv);
	glVertex3f(0,-i*1.5f-1,0);

	glTexCoord2f((n+1)*rh,rv);
	glVertex3f(1,-i*1.5f-1,0);
	glEnd();

// 	printf("%c",*c);
	c++;
	glTranslatef(1,0,0);
      }
//       printf("\n");
      glPopMatrix();
    }


    glDisable(GL_TEXTURE_2D);
    glColor3f(1,0,0);
    glBegin(GL_QUADS);
    glVertex3f(10,-current*1.5f+0.5f,-0.1f);
    glVertex3f(-1,-current*1.5f+0.5f,-0.1f);
    glVertex3f(-1,-current*1.5f-1.5f,-0.1f);
    glVertex3f(10,-current*1.5f-1.5f,-0.1f);
    glEnd();

    SDL_GL_SwapBuffers();
  }

   //   glDisable(GL_TEXTURE_2D);

   /* Free the stuff before leaving */
   for (int i=0;i<next;i++) {
     free(entries[i]);
   }
   free(entries);
}
