/*  $Id: main.h,v 1.17 2004/07/27 13:17:13 baloo Exp $ */

#ifndef MAIN_H
#define MAIN_H

#include "track.h"
#include "theme.h"
#include "car.h"
#include "base.h"

/** The Pixel Format flags */
extern int VideoFlags;              
/** Our Drawable portion of the window */
extern SDL_Surface * mainWindow;     

extern GLuint tex_id;

extern Track track;

extern Theme *plainTheme;
extern Theme *metalTheme;
extern Theme *legoTheme;

//extern Car car;

extern int now;

extern int laptime;

/* True: two players play side by side, false: single full screen
   player */
extern bool twoplay;

/* the one cell being returned when you ask for one that's out of
   field. */
extern Cell borderCell;

/** This controls our MainLoop */
void body(void);

/** This initializes the whole program. */
bool init(int argc,char *argv[]);

/** displays an editor interface. The function returns whenever the
    user closes the editor */
void editor();

/** "main menu". For now, just to select a track */
void menu();

#endif  // MAIN_H
