#ifndef LEGO_H
#define LEGO_H

#include "theme.h"

class Lego : public Theme {
 public:
  Lego();
  ~Lego();

  int number();
  void cell(int variant);
  void straightSides(Smooth *s,bool starting,bool ending,int variant);
  void straight(Smooth *s,bool starting,bool ending,bool startPoint,float interactAge,int variant);
  void curve(float h,int variant);
  void fan(Smooth *s,bool starting,bool ending,float angle,int variant);
  void wheel(Smooth *s,bool starting,bool ending,float angle,int variant);

  /** sine[x] = sinf(x*TWOPI/7) */
 private:
  float sine[8];
  /** cose[x] = cosf(x*TWOPI/7) */
  float cose[8];

  void button(float x,float y,float z);
};

#endif
