#include <math.h>

#include "base.h"
#include "lego.h"
#include "cell.h"
#include "smooth.h"

/* for straight */
#define ISMOOTHNESS 10
#define SSMOOTHNESS 10.0f

/* for curve */
#define CSMOOTHNESS 15
#define TOOCSMOOTH (2*CSMOOTHNESS)

/* for wheel */
/* cos(pi/5)/2 */
#define WHEELX 0.9510565162951535312
/* sin(pi/5)/2 */
#define WHEELY 0.3090169943749473958

Lego::Lego() {
  for (int i=0;i<=7;i++) {
    sine[i] = sinf(i*TWOPI/7);
    cose[i] = cosf(i*TWOPI/7);
  }
}
Lego::~Lego() {}

int Lego::number() {
  return 2;
}

/* do a little flat cylinder */
void Lego::button(float x,float y,float z) {
  glBegin(GL_QUAD_STRIP);
  for (int r=0;r<=7;r++) {
    glNormal3f(cose[r],
	       0,
	       sine[r]);
    glVertex3f(x+cose[r]*0.06f,
	       y,
	       z+sine[r]*0.06f);
    glVertex3f(x+cose[r]*0.06f,
	       y+0.03f,
	       z+sine[r]*0.06f);
  }
  glEnd();

  glBegin(GL_TRIANGLE_FAN);
  glNormal3f(0,1,0);
  for (int r=7;r>=0;r--) {
    glVertex3f(x+cose[r]*0.06f,
	       y+0.03f,
	       z+sine[r]*0.06f);
  }
  glEnd();
}

void Lego::cell(int variant) {
  glColor3f(0,0.9f,0);
  glBegin(GL_QUADS);
  glNormal3f(0,1,0);
  glVertex3f(0.05f,0,0.05f);
  glVertex3f(0.05f,0,0.95f);
  glVertex3f(0.95f,0,0.95f);
  glVertex3f(0.95f,0,0.05f);

  glNormal3f(SQHALF,SQHALF,0);
  glVertex3f(1,-0.05f,0);
  glVertex3f(0.95f,0,0.05f);
  glVertex3f(0.95f,0,0.95f);
  glVertex3f(1,-0.05f,1);

  glNormal3f(0,SQHALF,SQHALF);
  glVertex3f(1,-0.05f,1);
  glVertex3f(0.95f,0,0.95f);
  glVertex3f(0.05f,0,0.95f);
  glVertex3f(0,-0.05f,1);

  glNormal3f(-SQHALF,SQHALF,0);
  glVertex3f(0,-0.05f,1);
  glVertex3f(0.05f,0,0.95f);
  glVertex3f(0.05f,0,0.05f);
  glVertex3f(0,-0.05f,0);

  glNormal3f(0,-SQHALF,-SQHALF);
  glVertex3f(0,-0.05f,0);
  glVertex3f(0.05f,0,0.05f);
  glVertex3f(0.95f,0,0.05f);
  glVertex3f(1,-0.05f,0);
  glEnd();

  button(0.3f,0,0.3f);
  button(0.3f,0,0.7f);
  button(0.7f,0,0.3f);
  button(0.7f,0,0.7f);
}

void Lego::straightSides(Smooth *s,bool starting,bool ending,int variant) {
  //  float g=0.45f;

  glPushMatrix();
//   if (angle==1) {
//     glRotatef(90,0,1,0);
//     glTranslatef(-1,0,0);
//   }

  glBegin(GL_QUADS);

  for (int t=0;t<ISMOOTHNESS;t++) {
    //    if (t==ISMOOTHNESS/2) g = 1-g;

    /* left */
    glNormal3f(-1,0,0);
    glVertex3f(0.2f,0,t/SSMOOTHNESS);
    glVertex3f(0.2f,0,(t+1)/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0((t+1)/SSMOOTHNESS)-0.02f,(t+1)/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0(t/SSMOOTHNESS)-0.02f,t/SSMOOTHNESS);

    /* right */
    glNormal3f(1,0,0);
    glVertex3f(0.8f,s->height0(t/SSMOOTHNESS)-0.02f,t/SSMOOTHNESS);
    glVertex3f(0.8f,s->height0((t+1)/SSMOOTHNESS)-0.02f,(t+1)/SSMOOTHNESS);
    glVertex3f(0.8f,0,(t+1)/SSMOOTHNESS);
    glVertex3f(0.8f,0,t/SSMOOTHNESS);
  }

  //  glColor3f(1,0,0);

  if (starting) {
    glNormal3f(0,0,-1);
    glVertex3f(0.8f,0,0);
    glVertex3f(0.2f,0,0);
    glVertex3f(0.2f,s->height0(0)-0.02f,0);
    glVertex3f(0.8f,s->height0(0)-0.02f,0);
  }
  if (ending) {
    glNormal3f(0,0,1);
    glVertex3f(0.2f,0,1);
    glVertex3f(0.8f,0,1);
    glVertex3f(0.8f,s->height0(1)-0.02f,1);
    glVertex3f(0.2f,s->height0(1)-0.02f,1);
  }

  glEnd();

  glPopMatrix();

  cell(variant);
}

void Lego::straight(Smooth *s,bool starting,bool ending,bool savePoint,float interactAge,int variant) {
  float *k;

  if (savePoint) k=red;
  else k=yellow;

  glColor3fv(k);
  straightSides(s,starting,ending,variant);
  glColor3fv(k);

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,bright);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  /* Paint little buttons */
  for (int z=1;z<5;z++) {
    for (int x=2;x<4;x++) {
      button(x*0.2f,s->height0(z*0.2f)-0.02f,z*0.2f);
    }
  }


  glBegin(GL_QUAD_STRIP);

  //  glColor3f(0.7f,0.6f,0.6f);
  for (int t=0;t<=ISMOOTHNESS;t++) {
//     if (savePoint && t>0.1f*ISMOOTHNESS && t< 0.9f*ISMOOTHNESS)
//       glColor3f(1,0,0);
//     else
//       glColor3f(0.7f,0.6f,0.6f);
    glNormal3fv(s->normal0(0.05f+0.9f*t/SSMOOTHNESS));
    glVertex3f(0.8f,s->height0(0.05f+0.9f*t/SSMOOTHNESS)-0.02f,0.05f+0.9f*t/SSMOOTHNESS);
    glVertex3f(0.2f,s->height0(0.05f+0.9f*t/SSMOOTHNESS)-0.02f,0.05f+0.9f*t/SSMOOTHNESS);
//     glNormal3fv(s->normal0(0.05f+0.9f*(t+1)/SSMOOTHNESS));
//     glVertex3f(0.2f,s->height0(0.05f+0.9f*(t+1)/SSMOOTHNESS),(0.05f+0.9f*(t+1)/SSMOOTHNESS));
//     glVertex3f(0.8f,s->height0(0.05f+0.9f*(t+1)/SSMOOTHNESS),(0.05f+0.9f*(t+1)/SSMOOTHNESS));

  }

  glEnd();

  glBegin(GL_QUADS);

  /* starting bit */
  float h0 = s->height0(0)-0.03f;
  float h1 = s->height0(0.05f)-0.02f;
  float l = hypot(0.05f,h1-h0);

  glNormal3f(0,0.05f/l,(h0-h1)/l);
  glVertex3f(0.8f,h0,0);
  glVertex3f(0.2f,h0,0);
  glVertex3f(0.2f,h1,0.05f);
  glVertex3f(0.8f,h1,0.05f);

  /* ending bit */
  h0 = s->height0(0.95f)-0.02f;
  h1 = s->height0(1)-0.03f;
  l = hypot(0.05f,h1-h0);

  glNormal3f(0,0.05f/l,(h0-h1)/l);
  glVertex3f(0.8f,h0,0.95f);
  glVertex3f(0.2f,h0,0.95f);
  glVertex3f(0.2f,h1,1);
  glVertex3f(0.8f,h1,1);

  glEnd();

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

//   if (savePoint) {
//     glBegin(GL_QUADS);
//     //    glColor3f(interactAge<1000?1-interactAge/1000:0,0,0);
//     glVertex3f(0.22f,s->height0(0.22f)+0.005f,0.22f);
//     glVertex3f(0.22f,s->height0(0.78f)+0.005f,0.78f);
//     glVertex3f(0.78f,s->height0(0.78f)+0.005f,0.78f);
//     glVertex3f(0.78f,s->height0(0.22f)+0.005f,0.22f);
//     glEnd();
//   }
}

void Lego::curve(float hei,int variant) {
  //   float g=0.45f;
   hei -= 0.02f;
   cell(variant);
//   glBegin(GL_LINES);
//   glColor3f(0.5f,0.5f,0.5f);
//   glVertex3f(0,0,0); glVertex3f(1,0,0);
//   glVertex3f(0,0,0); glVertex3f(0,1,0);
//   glVertex3f(0,0,0); glVertex3f(0,0,1);

//   glVertex3f(1,1,0); glVertex3f(0,1,0);
//   glVertex3f(1,1,0); glVertex3f(1,0,0);
//   glVertex3f(1,1,0); glVertex3f(1,1,1);

//   glVertex3f(0,1,1); glVertex3f(1,1,1);
//   glVertex3f(0,1,1); glVertex3f(0,0,1);
//   glVertex3f(0,1,1); glVertex3f(0,1,0);

//   glVertex3f(1,0,1); glVertex3f(0,0,1);
//   glVertex3f(1,0,1); glVertex3f(1,1,1);
//   glVertex3f(1,0,1); glVertex3f(1,0,0);
//   glEnd();


  /* sides */
   glColor3f(0.5f,0.5f,0.5f);
   glBegin(GL_QUADS);

   for (int i=0;i<CSMOOTHNESS;i++) {
    //    if (i%3==0) g = 1-g;

    //     glColor3f(g,g,0.5f);

     /* left */
     glNormal3f(-cosf(i*(PI/TOOCSMOOTH)),0,-sinf(i*(PI/TOOCSMOOTH)));
     glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.15f,hei,0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.15f);
     glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.15f,0,  0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.15f);
     glNormal3f(-cosf((i+1)*(PI/TOOCSMOOTH)),0,-sinf((i+1)*(PI/TOOCSMOOTH)));
     glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.15f,0,  0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.15f);
     glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.15f,hei,0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.15f);

     /* right */
     glNormal3f(cosf(i*(PI/TOOCSMOOTH)),0,sinf(i*(PI/TOOCSMOOTH)));
     glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.75f,0,  0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.75f);
     glVertex3f(0.05f+cosf(i    *(PI/TOOCSMOOTH))*0.75f,hei,0.05f+sinf(i    *(PI/TOOCSMOOTH))*0.75f);
     glNormal3f(cosf((i+1)*(PI/TOOCSMOOTH)),0,sinf((i+1)*(PI/TOOCSMOOTH)));
     glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.75f,hei,0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.75f);
     glVertex3f(0.05f+cosf((i+1)*(PI/TOOCSMOOTH))*0.75f,0,  0.05f+sinf((i+1)*(PI/TOOCSMOOTH))*0.75f);
     // }

//   if (starting) {
//     glNormal3f(0,0,-1);
//     glVertex3f(0.2f,0,0);
//     glVertex3f(0.8f,0,0);
//     glVertex3f(0.8f,hei,0);
//     glVertex3f(0.2f,hei,0);
//   }
//   if (ending) {
//     glNormal3f(0,0,1);
//     glVertex3f(0.2f,0,1);
//     glVertex3f(0.2f,hei+slope,1);    
//     glVertex3f(0.8f,hei+slope,1);
//     glVertex3f(0.8f,0,1);
//   }

  }

  /* starting and ending vertical bits */
  glNormal3f(-1,0,0);
  glVertex3f(0.2f,0,0);
  glVertex3f(0.2f,0,0.05f);
  glVertex3f(0.2f,hei,0.05f);
  glVertex3f(0.2f,hei,0);

  glNormal3f(1,0,0);
  glVertex3f(0.8f,0,0);
  glVertex3f(0.8f,hei,0);
  glVertex3f(0.8f,hei,0.05f);
  glVertex3f(0.8f,0,0.05f);

  glNormal3f(0,0,-1);
  glVertex3f(0,0,0.2f);
  glVertex3f(0,hei,0.2f);
  glVertex3f(0.05f,hei,0.2f);
  glVertex3f(0.05f,0,0.2f);

  glNormal3f(0,0,1);
  glVertex3f(0,0,0.8f);
  glVertex3f(0.05f,0,0.8f);
  glVertex3f(0.05f,hei,0.8f);
  glVertex3f(0,hei,0.8f);

  glEnd();


  /* top */

  glColor3f(0.7f,0.6f,0.6f);
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,bright);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
  glBegin(GL_QUADS);
  glNormal3f(0,1,0);

  for (int i=0;i<CSMOOTHNESS;i++) {
    glVertex3f(0.05f+cosf(PI*i/TOOCSMOOTH)*0.75f,hei,0.05f+sinf(PI*i/TOOCSMOOTH)*0.75f);
    glVertex3f(0.05f+cosf(PI*i/TOOCSMOOTH)*0.15f,hei,0.05f+sinf(PI*i/TOOCSMOOTH)*0.15f);
    glVertex3f(0.05f+cosf(PI*(i+1)/TOOCSMOOTH)*0.15f,hei,0.05f+sinf(PI*(i+1)/TOOCSMOOTH)*0.15f);
    glVertex3f(0.05f+cosf(PI*(i+1)/TOOCSMOOTH)*0.75f,hei,0.05f+sinf(PI*(i+1)/TOOCSMOOTH)*0.75f);
  }
  glEnd();

  glBegin(GL_QUADS);
  /* starting bit */
  float h0 = hei-0.01f;
  float h1 = hei;
  float l = hypot(0.05f,h1-h0);

  glNormal3f(0,0.05f/l,(h0-h1)/l);
  glVertex3f(0.8f,h0,0);
  glVertex3f(0.2f,h0,0);
  glVertex3f(0.2f,h1,0.05f);
  glVertex3f(0.8f,h1,0.05f);

  /* ending bit */
//   h0 = s->height0(0.95f);
//   h1 = s->height0(1)-0.01f;
//   l = hypot(0.05f,h1-h0);

  glNormal3f((h0-h1)/l,0.05f/l,0);
  glVertex3f(0.05f,h1,0.8f);
  glVertex3f(0.05f,h1,0.2f);
  glVertex3f(0,h0,0.2f);
  glVertex3f(0,h0,0.8f);
  glEnd();

  button(0.4f,hei,0.2f);
  button(0.6f,hei,0.2f);
  button(0.2f,hei,0.4f);
  button(0.4f,hei,0.4f);
  button(0.2f,hei,0.6f);

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);
}

void Lego::fan(Smooth *s,bool starting,bool ending,float angle,int variant) {
  straightSides(s,starting,ending,variant);
  glPushMatrix();
  glTranslatef(0.5f,s->height0(0.5f),0.5f);
  glRotatef(angle,0,1,0);
  glColor3f(0.1f,0.3f,0.7f);
  glDisable(GL_CULL_FACE);
  for (int i=0;i<3;i++) {
    glBegin(GL_TRIANGLES);
    glVertex3f(0,0,0);
    glVertex3f(0.4f,0,0);
    glVertex3f(0.3f,-0.2f,0.2f);
    glEnd();
    glRotatef(120,0,1,0);
  }
  glEnable(GL_CULL_FACE);
  glPopMatrix();
  
}

void Lego::wheel(Smooth *s,bool starting,bool ending,float angle,int variant) {
  straight(s,starting,ending,false,10000,variant);

  float f = 0.5f;

  /* debug display starts */
//   glColor3f(1,0,0);
//   glBegin(GL_LINES);
//   for (int i=0;i<40;i++) {
//     glVertex3f(i/40.0f,0.7f,0.29f);
//     glVertex3f(i/40.0f,height(i/40.0f,0.7f,0.5f),0.29f);
//   }
//   glEnd();
  /* debug display ends */

  glTranslatef(0.5f,s->height0(0.5f)+0.4f,0);

  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,bright);
  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,3);

  glColor3f(0,0,1);
  glRotatef(angle,0,0,1);
  for (int i=0;i<20;i++) {
    if (i%2==0) {
      /* "tooth" side */
      glBegin(GL_QUADS);
      glNormal3f(f<0.4f?-1:1,0,0);
      glVertex3f(0,-f,0.7f);
      glVertex3f(0,-f,0.3f);
      
      f = 0.8f-f;
//       f = 0.5f-f;

      glVertex3f(0,-f,0.3f);
      glVertex3f(0,-f,0.7f);
      glEnd();
    } else if (i%4==1) {
      button(0,0.5f,0.4f);
      button(0,0.5f,0.6f);
    }

    glNormal3f(0,0,-1);
    glBegin(GL_TRIANGLES);
    /* front */
    glVertex3f(0, 0,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(0,-f,0.3f);
    glNormal3f(0,0,1);
    /* back */
    glVertex3f(0, 0,0.7f);
    glVertex3f(0,-f,0.7f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();

    /* side */
    glBegin(GL_QUADS);
    glNormal3f(0,-1,0);
    glVertex3f(0,-f,0.7f);
    glVertex3f(0,-f,0.3f);

    glNormal3f(WHEELY,-WHEELX,0);
    glVertex3f(WHEELY*f,-WHEELX*f,0.3f);
    glVertex3f(WHEELY*f,-WHEELX*f,0.7f);
    glEnd();
    glRotatef(18,0,0,1);
  }

  //  glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,0);
  glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,black);
}

//void Lego::bouncing() {}
