#include "main.h"

//#include "main.h"
#include "cell.h"
#include "lego.h"
#include "metal.h"

GLuint tex_id;
int VideoFlags = 0;                 // Video Flags for the Create Window function
SDL_Surface * mainWindow = NULL;    // drawing surface on the SDL window

Track track;

Theme *plainTheme;
Theme *metalTheme;
Theme *legoTheme;

// Car car;
Cell borderCell;

Uint32 triggerRefresh(Uint32 interval,void *param) {
  static SDL_Event ev;

  /* just send a dummy event */
  ev.type=SDL_USEREVENT;
  ev.user.code=2;
  ev.user.data1=NULL;
  ev.user.data2=NULL;

  SDL_PushEvent(&ev);
  return interval;
}

bool init( int argc,char *argv[] )
{

  twoplay = argc>1;

  borderCell.init();

  plainTheme = new Theme();
  legoTheme = new Lego(); 
  metalTheme = new Metal();
  // WARN - themes never get freed. Also they should probably be
  // loaded lazily.

  if (!track.load("maps/default")) {
    printf("loading default track failed\n");
    return false;
  }

  //track.demoTrack(1);

  //  car.init(1.5f,0.5f,0);

  if( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_TIMER ) < 0 )                // try to initialize SDL video module
    {
        cerr << "Failed initializing SDL Video : " << SDL_GetError() << endl;      // report error if it fails
    }

    VideoFlags    = SDL_OPENGL|SDL_HWPALETTE;

    const SDL_VideoInfo * VideoInfo = SDL_GetVideoInfo();     // query SDL for information about our video hardware

    if(VideoInfo == NULL)                                     // if this query fails
    {
        cerr << "Failed getting Video Info : " << SDL_GetError() << endl;          // report error
        exit(1);
    } 

    ///////////// we set the system dependant flags here
    if(VideoInfo -> hw_available)                      // is it a hardware surface
        VideoFlags |= SDL_HWSURFACE;
    else
        VideoFlags |= SDL_SWSURFACE;

    // Blitting is fast copying / moving /swapping of contiguous sections of memory
    // for more about blitting check out : http://www.csc.liv.ac.uk/~fish/HTML/blitzman/bm_blitter.html
    if(VideoInfo -> blit_hw)                            // is hardware blitting available
        VideoFlags |= SDL_HWACCEL;
 
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );      // tell SDL that the GL drawing is going to be double buffered
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE,   SCREEN_DEPTH);         // size of depth buffer 
    SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);       // we aren't going to use the stencil buffer
    SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);     // this and the next three lines set the bits allocated per pixel -
    SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);   // - for the accumulation buffer to 0
    SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
    SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);

    mainWindow = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH, VideoFlags);     // SCREEN_DEPTH is macro for bits per pixel

    if( mainWindow == NULL )                            // if window creation failed
    {
        cerr << "Failed to Create Window : " << SDL_GetError() << endl;         // report error 
        exit(2);
    } 

    SDL_AddTimer(20,&triggerRefresh,0);

  // gouraud mode (WAS:GL_FRONT_AND_BACK)
  glPolygonMode(GL_FRONT, GL_FILL);
  //  glPolygonMode(GL_BACK, GL_POINT);
  glShadeModel(GL_SMOOTH);

  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);

  /*  glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
  glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
  glHint( GL_POLYGON_SMOOTH_HINT, GL_NICEST );
  glHint( GL_FOG_HINT, GL_NICEST );
  glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST ); 
  */

  glEnable(GL_NORMALIZE); // Need this to cancel glScale for normals

  glEnable(GL_LIGHTING);
  glColorMaterial ( GL_FRONT, GL_AMBIENT_AND_DIFFUSE );
  glEnable ( GL_COLOR_MATERIAL );
  glEnable ( GL_LIGHT0);

  glEnable (GL_BLEND); glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  /* a bit experimental - this is to have textures that have either
     alpha=0 or alpha=1, to avoid having to z-sort polygons (for
     now) */
  glAlphaFunc ( GL_GREATER, 0.1 );  glEnable ( GL_ALPHA_TEST );

  //  glEnable(GL_TEXTURE_2D);
 
    // How Image data are stored in the GPU's memory    
  //  glPixelStorei( GL_UNPACK_ALIGNMENT, 1 ); // ( do we care? )

  if (!loadTexture("textures/alphabet.jpeg",&tex_id)) {
    return false;
  }

  if (!(plainTheme->init() && metalTheme->init() && legoTheme->init())) {
    return false;
  }
    
  //glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, tex->env_mode );  
    
  glClearDepth( 1.0f ); 
  glEnable( GL_DEPTH_TEST );

  return true;
}
