#include <math.h>
#include "fan.h"
#include "main.h"

Fan::Fan() {}
Fan::~Fan() {}

// void Fan::init(int angle,float hei0,float slope0,float hei1,float slope1) {
  
// }

Cell *Fan::clone() {
  Fan *cel = new Fan();
  cel->init(angle, d, c, a+b+c+d, 3*a+2*b+c);
  return cel;
}

void Fan::interact(Car *c,float t) {
  float p[3];
  float h;
  
  c->getPosition(p);

  p[0] -= floorf(p[0]);
  p[2] -= floorf(p[2]);

  h = height(p[0],0,p[2]);

  if (h==0) return; // car is not on track

  h = p[1]-h; // distance from fan to car

  if (h<0) h=0;

  //  printf("%f -> %f\n",h,expf(-h));

  c->accelerate(0,expf(-h)*0.17f,0);
}

void Fan::render(Theme *theme) {
  glPushMatrix();
  if (angle==1) {
    glRotatef(90,0,1,0);
    glTranslatef(-1,0,0);
  }

  theme->fan(this,starting,ending,now,variant);
  glPopMatrix();
}

void Fan::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," f %d %f %f %f %f %c%c",angle,a,b,c,d,starting?'[':'-',ending?']':'-');
}
