//#include "ball.h"

#include "main.h"
#include "button.h"

#include "curve.h"
#include "fan.h"
#include "smooth.h"
#include "straight.h"

/* The index of the "slopeh" button in but[] */
#define SLOPEH 9
/* the index of the "sp" (savepoint) button in but[] */
#define SPT 10
/* how many buttons there are... */
#define BUTCNT 11

void editor() {
  bool done=false;
  SDL_Event event;
  float lightPos[] = {0.1f,1.0f,1.0f,0};
  Button *selected = 0;
  bool mousePressed=false;
  float buty = -9; // next toolbar button position
  int buti = 0; // next toolbar button index

  int wid = track.getWid();
  int len = track.getLen();

  /*** save point editor info ***/
  bool speditor=false; // whether we're editing save points
  int savePointId=0; // id of latest added savepoint
  Cell *lastSavePoint=0; // latest added savepoint

  /*** slope editor info ***/
  int slopeeditor=0; // 0:off 1:horiz 2:vert
  int direction=1; // which way should slopeeditor start?
  // current mouse position:
  int m=0; // horizontal coordinate in cells
  int s=0; // 0: left half, 1: right half
  int m2,s2; // temp vals for comparison
  float v=0; // vertical coordinate
  // latest anchor:
  int ancm=-1; // horizontal coordinate in cells. -1 = no anchor set
  float ancv=0; // vertical coordinate

  int x=0,z=0; // selected cell

  Button but[BUTCNT];
  Cell cell;
  cell.init();
  but[buti++].init(15,buty,&cell,true); buty+=1.5f;

  Smooth tileh;
  tileh.init(1,0.5f,0,0.5f,0);
  but[buti++].init(15,buty,&tileh,true); buty+=1.5f;
  tileh.putWall(0,true);
  tileh.putWall(2,true);

  Smooth tilev;
  tilev.init(0,0.5f,0,0.5f,0);
  but[buti++].init(15,buty,&tilev,true); buty+=1.5f;
  tilev.putWall(1,true);
  tilev.putWall(3,true);

  Curve tile[4]; 
  for (int i=0;i<4;i++) {
    tile[i].init(i,0,0.5f);
    but[buti++].init(15,buty,&(tile[i]),true); buty+=1.5f;
  }

  Fan fanh,fanv;
  fanh.init(1,0.5f,0,0.5f,0);
  but[buti++].init(15,buty,&fanh,true); buty+=1.5f;
  fanh.putWall(0,true);
  fanh.putWall(2,true);

  fanv.init(0,0.5f,0,0.5f,0);
  but[buti++].init(15,buty,&fanv,true); buty+=1.5f;
  fanv.putWall(1,true);
  fanv.putWall(3,true);

  Smooth slopeh;
  slopeh.init(1,0.5f,2,0.5f,2);
  but[buti++].init(15,4.5f,&slopeh,false); buty+=1.5f;
  slopeh.putWall(0,true);
  slopeh.putWall(2,true);

  Straight sp;
  sp.init(0,0,0.5f);
  but[buti++].init(15,6,&sp,true); buty+=1.5f;
  sp.setSavePoint(42,false);
  sp.putWall(0,true);
  sp.putWall(2,true);

  glMatrixMode(GL_PROJECTION);                        // Select The Projection Matrix
  glLoadIdentity();                                   // Reset The Projection Matrix
  glPerspective( 45.0f, (GLfloat)SCREEN_WIDTH/(GLfloat)SCREEN_HEIGHT, 1.0f, 10000.0f );
  glMatrixMode(GL_MODELVIEW);
  glViewport(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

  while (!done) {

    now=SDL_GetTicks(); // for animated objects to display properly

    SDL_WaitEvent(0);

    while( SDL_PollEvent(& event) )
      {
//  	if (event.type == SDL_KEYDOWN || event.type == SDL_KEYUP) {
//  	  printf("key event: %s %d\n",(event.type==SDL_KEYUP?"up":"down"),event.key.keysym.sym);
//  	}
	
	bool found = false;
	for (int i=0;i<BUTCNT;i++) {
	  if (but[i].event(&event)) {
	    if (selected) selected->release();
	    selected = &(but[i]);
	    found = true;
	    if (selected==but+SLOPEH) {
	      if (slopeeditor!=0)
		slopeeditor=0;
	      else 
		direction = 3-direction;
	    } else if (selected==but+SPT) {
	      speditor = !speditor;
	      /* erase all save points */
	      for (int i=0;i<wid;i++) {
		for (int j=0;j<len;j++) {
		  track.getCell(i,j)->setSavePoint(0,false);
		}
	      }
	      savePointId = 0;
	      lastSavePoint = 0;
	    }
	    break;
	  }
	}
	if (!found) {
	  switch ( event.type ) {
	  case SDL_QUIT :
	    done=true;
	    break;
	  case SDL_KEYDOWN :           
	    switch (event.key.keysym.sym) {
	    case SDLK_q:
	    case SDLK_ESCAPE:
	      done=true;
	      break;
	    case SDLK_s:
	      track.save("maps/default");
	      break;
	    default:
	      break;
	    }
	    break;
	  case SDL_MOUSEBUTTONDOWN :
	    mousePressed = true;
	    if (slopeeditor!=0) ancm=-1;
	    /* no "break": to apply selected when mouse is clicked,
	       even if not moving the mouse... */
	    //	    break;
	  case SDL_MOUSEMOTION :
	    if (slopeeditor!=0) {
	      m2 = (int)((event.motion.x-18)/27.69230769f);
	      s2 = ((event.motion.x-18)-m*27.69230769f)<14?0:1;
	      v = (359-event.motion.y)/27.69230769f;
	      if (mousePressed) {
		/* see if we're setting an anchor (previous mouse point
		   was on the same cell on the other side) */
		if (m==m2 && s+s2==1) {
		  ancm = m;
		  ancv = v;
		}
		/* see if we're writing a slope (an anchor was set and
		   we changed cell) */
		if (ancm!=-1 && m!=m2) {
		  float dv = 2*(v-ancv);
		  int side = slopeeditor==1?0:3; // setHeight()'s 1st param 
		  int otherm = m+m2-ancm; // ;-)
		  if (m2<ancm || m<ancm) {side=(side+2)%4;dv = -dv;} // going leftwards
		  track.getCell(slopeeditor==1?ancm:x,slopeeditor==1?z:ancm)->setHeight(side,v,dv);
		  track.getCell(slopeeditor==1?otherm:x,slopeeditor==1?z:otherm)->setHeight((side+2)%4,v,dv);

// 		  printf("%d,%d; %d->%d\n",m,m2,ancm,otherm);
		}
	      }
	      
	      m=m2;
	      s=s2;
	      //	      printf("%d\n",(int)((event.motion.x-18)-m*27.69230769f));
	      //	      if (slopeeditor==1) x=m; else z=m;
	    } else {
	      x = (event.motion.x-48)/24;
	      z = (event.motion.y-23)/24;
	    }

	    if (selected && mousePressed) {
	      if (x>=0 && x<wid && z>=0 && z<len) {
		if (selected==but+SLOPEH) {
		  slopeeditor=direction;
		} else if (selected==but+SPT) {
		  if (lastSavePoint) {
		    /* mark latest added as no longer being the last */
// 		    printf("sp %d is no longer the last\n",savePointId);
		    lastSavePoint->setSavePoint(savePointId,false);
		  }
		  savePointId++;
		  lastSavePoint = track.getCell(x,z);
		  lastSavePoint->setSavePoint(savePointId,true);
// 		  printf("setting sp %d\n",savePointId);
		  if (savePointId==1) {
		    /* first save point is also start point */
		    track.setStartPoint(x,lastSavePoint->height(0.5f,1000,0.5f),z);
		  }
		} else {
		  track.setCell(x,z,selected->build());
		  /* put or remove walls */
		  /* right */
		  /* "connect out" */
		  bool co = track.getCell(x+1,z)->isConnected(2);
		  /* "connect in" */
		  bool ci = track.getCell(x,z)->isConnected(0);
// 		  printf("0:%d,%d\n",ci,co);
		  bool w = ! (ci & co);
		  if (co) track.getCell(x+1,z)->putWall(2,w);
		  if (ci) track.getCell(x,z)->putWall(0,w);
		  /* top */
		  co = track.getCell(x,z-1)->isConnected(3);
		  ci = track.getCell(x,z)->isConnected(1);
// 		  printf("1:%d,%d\n",ci,co);
		  w = ! (ci & co);
		  if (co) track.getCell(x,z-1)->putWall(3,w);
		  if (ci) track.getCell(x,z)->putWall(1,w);
		  /* left */
		  co = track.getCell(x-1,z)->isConnected(0);
		  ci = track.getCell(x,z)->isConnected(2);
// 		  printf("2:%d,%d\n",ci,co);
		  w = ! (ci & co);
		  if (co) track.getCell(x-1,z)->putWall(0,w);
		  if (ci) track.getCell(x,z)->putWall(2,w);
		  /* bottom */
		  co = track.getCell(x,z+1)->isConnected(1);
		  ci = track.getCell(x,z)->isConnected(3);
// 		  printf("3:%d,%d\n",ci,co);
		  w = ! (ci & co);
		  if (co) track.getCell(x,z+1)->putWall(1,w);
		  if (ci) track.getCell(x,z)->putWall(3,w);
// 		  printf("\n");
		}
	      }
	    }

	    if (x<0) x=0;
	    else if (x>=wid) x=wid-1;
	    if (z<0) z=0;
	    else if (z>=len) z=len;
	    break;
	  case SDL_MOUSEBUTTONUP :
	    mousePressed = false;
	    break;
	  }
	}
      }

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer

  glLoadIdentity();  

  /* camera motion comes here */
  if (slopeeditor==1) {
    glTranslatef(-21,0,-z-26);
  } else if (slopeeditor==2) {
    glRotatef(90,0,1,0);
    glTranslatef(26-x,0,-21);
  } else {
    glRotatef(90,1,0,0);
    glTranslatef(-23,-30,-14);
  }

  glLightfv( GL_LIGHT0,GL_POSITION,lightPos);

  /* track */
  if (slopeeditor==1)
    track.renderh(z);
  else if (slopeeditor==2)
    track.renderv(x);
  else
    track.render();

  /* grid */
  glColor3f(1,1,1);

  if (slopeeditor==1) {
    glBegin(GL_LINES);
    glVertex3f(0,0,z);
    glVertex3f(wid,0,z);
    for (int i=0;i<=wid;i++) {
      glVertex3f(i,0,z);
      glVertex3f(i,-1,z);
    }
    glEnd();

    glBegin(GL_QUADS);
    glColor3f(1,0,0);
    glVertex3f(x+1,0, z);
    glVertex3f(x,  0, z);
    glVertex3f(x,  -1,z);
    glVertex3f(x+1,-1,z);
    glEnd();

  } else if (slopeeditor==2) {
    glBegin(GL_LINES);
      glVertex3f(x,0,0);
      glVertex3f(x,0,len);
    for (int i=0;i<=len;i++) {
      glVertex3f(x,0,i);
      glVertex3f(x,-1,i);
    }
    glEnd();

    glBegin(GL_QUADS);
    glColor3f(1,0,0);
    glVertex3f(x,0, z+1);
    glVertex3f(x,0, z);
    glVertex3f(x,-1,z);
    glVertex3f(x,-1,z+1);
    glEnd();
  } else {
    glBegin(GL_LINES);
    for (int i=0;i<=wid;i++) {
      glVertex3f(i,0,0);
      glVertex3f(i,0,len);
    }
    for (int i=0;i<=len;i++) {
      glVertex3f(0,0,i);
      glVertex3f(wid,0,i);
    }
    glEnd();
    glBegin(GL_QUADS);
    glColor3f(1,0,0);
    bool fh = selected==but+SLOPEH&&direction==1; // full h
    bool fv = selected==but+SLOPEH&&direction==2; // full v
    glVertex3f(fh?wid:x+1,0,fv?0  :z);
    glVertex3f(fh?0  :x,  0,fv?0  :z);
    glVertex3f(fh?0  :x,  0,fv?len:z+1);
    glVertex3f(fh?wid:x+1,0,fv?len:z+1);
    glEnd();
  }

  //  player1.render();

  /* toolbar */
  glLoadIdentity();
  for (int i=0;i<BUTCNT;i++) 
    but[i].render();

  /* now put the info at the top */
//   glLoadIdentity();
//   glDisable(GL_LIGHTING);
//   glDisable(GL_DEPTH_TEST);

//   player->renderinfo();
//   if (laptime) {
//     glPushMatrix();
//     glColor3f(1,0,0);
//     glTranslatef(0.6f,0.7f,-2);
//     glScalef(0.04f,0.04f,0.04f);
//     printTime(laptime);
//     glPopMatrix();
//   }
//   glEnable(GL_DEPTH_TEST);
//   glEnable(GL_LIGHTING);

    SDL_GL_SwapBuffers(); 

  }


}
