#ifndef CURVE_H
#define CURVE_H

#include <stdio.h>
#include "cell.h"

class Curve : public Cell {
 public:
  Curve();
  ~Curve();

  bool init(int angle,float slope,float hei);
  Cell *clone();
  //  void setBoundary(bool starting,bool ending);
  void setHeight(int side,float h,float s);

  void render(Theme *theme);
  float height(float x,float y,float z);
  float *normal(float x,float y,float z);
  bool isConnected(int side);
  float *checkWall(float x0,float y0,float z0,float x1,float y1,float z1);

  void writeTo(FILE *f);
  bool initFrom(FILE *f);

 private:

  int angle; // 0: north-east quadrant, 1: north-west quadrant, 2: sw, 3: se.
  float slope; // usually positive, lateral slope to help taking it at
               // high speed (the center of the curve is horizontal)
  float hei;

/*   bool starting; /\* if the S (E) end comes out of a "cell" *\/ */
/*   bool ending; /\* if the N (W) end goes into a "cell" *\/ */

};

#endif
