#include <math.h>

#include "curve.h"
#include "main.h"

Curve::Curve() {}

Curve::~Curve() {}

bool Curve::init(int angle,float slope,float hei) {
  Cell::init();

  this->angle = angle;
  this->slope = slope;
  this->hei = hei;

//   starting=false;
//   ending=false;

  //  t = 0; //debug
  return true;
}

Cell *Curve::clone() {
  Curve *c = new Curve();
  c->init(angle,slope,hei);
  return c;
}

// void Curve::setBoundary(bool starting,bool ending) {
//   this->starting = starting;
//   this->ending = ending;
// }

void Curve::setHeight(int side,float h,float s) {
//   printf("angle %d, side %d\n",angle,side);
  if (isConnected(side)) {
    if (hei!=h) {
      /* We check anything changed before telling the neighbours, to
	 avoid loops */
      hei = h;
//       printf("setting height from side %d.",side);
      if (side==((angle+1)%4)) {
	side=(angle+2)%4;
      } else if (side==((angle+2)%4)) {
	side=(angle+1)%4;
      }
//       printf("transmitting towards %d (%d,%d@%d).",side,x+(side==0?1:(side==2?-1:0)),
// 	     z+(side==3?1:(side==1?-1:0)),(side+2)%4);
      track.getCell(x+(side==0?1:(side==2?-1:0)),
		    z+(side==3?1:(side==1?-1:0)))->setHeight
	((side+2)%4,h,0);
//       printf("\n");
    }
  }
}

bool Curve::isConnected(int side) {
  return side==((angle+1)%4) || side==((angle+2)%4);
}

float *Curve::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  float r0,r1;
  static float nrml[3];
  //  printf("%f,%f -> ",x0,z0);

  if (angle==1||angle==2) {z0=1-z0;z1=1-z1;}
  if (angle==3||angle==2) {x0=1-x0;x1=1-x1;}
  //  printf("%f,%f\n",x0,z0);


  r1 = x1*x1+z1*z1; // endpoint sq-radius
  if (r1<0.04f || r1>0.64f) return normal(x1,y1,z1); // endpoint off track: no walls

  /* now endpoint is on track */
  r0 = x0*x0+z0*z0; // startpoint sq-radius
  if (r0<0.04f || r0>0.64f) { // startpoint off track: boom
    r0=sqrtf(r0);
    //    printf("%f,%f (%f), angle %i\n",x0,z0,r0,angle);
    nrml[0] = x0/r0;
    nrml[1] = 0;
    nrml[2] = z0/r0;
    /* (up to +/- 1) */
    if (angle==1||angle==3) {nrml[2]=-nrml[2];}

    return nrml;
  }

  /* now both start and endpoint on track and we assume no transversal
     walls... */

  return normal(x1,y1,z1);
}


void Curve::render(Theme *theme) {

  //  t +=0.1f; // debug

  glPushMatrix();
  if (angle!=0) {
    glRotatef(90*angle,0,1,0);
    glTranslatef((angle==1 || angle==2)?-1:0,0,
		 (angle==3 || angle==2)?-1:0);
  }

  theme->curve(hei,variant);

  glPopMatrix();
}

float Curve::height(float x,float y,float z) {

//   printf("%f,%f",x,z);

  if (angle==1||angle==2) z = 1-z;
  if (angle==3||angle==2) x = 1-x;

//   printf(" -> %f,%f",x,z);

  float r = x*x+z*z; // (squared) [R]adius

//   printf(" => %f\n",r);

  if (r<0.04f || r>0.64f) return 0;

  else if (variant!=0 && hei>y+0.8f) return 0;
  else return hei;
}

float *Curve::normal(float x,float y,float z) {
  static float v[]={0,1,0};

  return v;
}

void Curve::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," c %d %f %f",angle,slope,hei);
}

bool Curve::initFrom(FILE *f) {
  int a;
  float s,h;

  int n = fscanf(f," %d %f %f",&a,&s,&h);
  if (n<3) {
    printf("found %d items, expected 3\n",n);
    return false;
  }
  if (!init(a,s,h)) return false;
  return true;
}
