#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <SDL/SDL.h>
#include "car.h"

/** connects sdl events to a car. Having more than one instance allows
    controlling more than one car simultaneously */

class Controller {
 public:
  Controller();
  ~Controller();

  /* Start controlling that car with those keys */
  void attach(Car *c, Camera *cam,  SDLKey left, SDLKey right, SDLKey fast, SDLKey slow, SDLKey camera);

  /** Notify this controller of a keyboard event. Returns true if
      something happened, false if it should be passed on to the next
      controller */
  bool event(SDL_Event e);

 private:
  SDLKey left;
  SDLKey right;
  SDLKey fast;
  SDLKey slow;

  SDLKey camera;

  Car *car;
  Camera *cam;
};

#endif
