#include "controller.h"

Controller::Controller() {}

Controller::~Controller() {}

/* Start controlling that car with those keys */
void Controller::attach(Car *c, Camera *cam, SDLKey left, SDLKey right, SDLKey fast, SDLKey slow, SDLKey camera) {
  this->car = c;
  this->cam = cam;
  this->left = left;
  this->right = right;
  this->fast = fast;
  this->slow = slow;
  this->camera = camera;
}

  /** Notify this controller of a keyboard event. Returns true if
      something happened, false if it should be passed on to the next
      controller */
bool Controller::event(SDL_Event e) {
  switch ( e.type )
    {
    case SDL_KEYDOWN :           
      if (e.key.type==SDL_KEYDOWN) {
	if (e.key.keysym.sym==left) {
	  car->turn(-1);
	} else if (e.key.keysym.sym==right) {
	  car->turn(1);
	} else if (e.key.keysym.sym==fast) {
	  car->engine(1);
	} else if (e.key.keysym.sym==slow) {
	  car->engine(-1);
	} else if (e.key.keysym.sym==camera) {
	  cam->switchMode();
	} else {
	  return false;
	}
	return true;
      }
      break;
    case SDL_KEYUP :
      if (e.key.keysym.sym==left ||
	  e.key.keysym.sym==right) {
	car->turn(0);
      } else if (e.key.keysym.sym==fast ||
		 e.key.keysym.sym==slow) {
	car->engine(0);
      } else {
	return false;
      }
      return true; // one of the above two matched
    }
  return false;
}

