#include "base.h"

#include "cell.h"

#include "bouncing.h"
#include "curve.h"
#include "fan.h"
#include "smooth.h"
#include "wheel.h"
#include "straight.h"
#include "main.h"

Cell::Cell() {}
Cell::~Cell() {}

bool Cell::init() {
  x = -2;
  z = -2;
  savePoint = 0;
  variant = 0;
  last = false;
  return true;
}

void Cell::setCoordinates(int x,int z) {
  this->x = x;
  this->z = z;
}

Cell *Cell::clone() {
  Cell *c = new Cell();
  c->init();
  return c;
}

void Cell::render(Theme *theme) {
  theme->cell(variant);
}

bool Cell::isConnected(int side) {
  return false;
}

void Cell::putWall(int side,bool wall) {}

float *Cell::checkWall(float x0,float y0,float z0,float x1,float y1,float z1) {
  return normal(x1,y1,z1);
}

void Cell::setHeight(int side,float h,float s) {}

void Cell::setVariant(int variant) {
  this->variant = variant;
}

void Cell::interact(Car *c,float t) {
}

float Cell::height(float x,float y,float z) {
  return 0;
}

float *Cell::normal(float x,float y,float z) {
  static float n[3] = {0,1,0};
  
  return n;
}

void Cell::setSavePoint(int n,bool last) {
//   printf("setting save point %x\n",this);
  this->savePoint = n;
  this->last = last;
}

int Cell::isSavePoint(int *lastPoint) {
  if (savePoint) {
    if (*lastPoint == savePoint-1) {
      if (last) {
	/* the next id we should hit is 1 */
	*lastPoint = 0;
      } else {
	*lastPoint = savePoint;
      }
      if (savePoint == 1) {
	return 3;
      } else {
	return 2;
      }
    }
    return 1;
  }
  return 0;
}

bool Cell::preferredAngle(float *angle) {
  return false;
}

void Cell::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," -");
}

void Cell::prefixTo(FILE *f) {
  fprintf(f,"%d %c %d",savePoint,last?'l':'-',variant);
}

bool Cell::initFrom(FILE *f){
  init();
  return true;
}

Cell *readFrom(FILE *f,Multicell *m) {
  int savePoint;
  char last;
  char cname;
  int variant;
  char c; // if all goes well, either '\n' or ';'.

  Cell *cell; 

  if (fscanf(f,"%d %c %d %c",&savePoint,&last,&variant,&cname)<3) {
    printf("bad line prefix\n");
    return 0;
  }
  
  switch (cname) {
  case 'b': cell = new Bouncing();
    break;
  case 'c': cell = new Curve();
    break;
  case 'f': cell = new Fan();
    break;
  case 'l': cell = new Straight();
    break;
  case 's': cell = new Smooth();
    break;
  case 'w': cell = new Wheel();
    break;
  case '-': cell = new Cell(); 
    break;
  default:
    printf("unknown cell type '%c'\n",cname);
    return 0;
  }

  if (!cell->initFrom(f)) {
    delete cell;
    return 0;
  }

  cell->setVariant(variant);

  if (fread(&c,1,1,f)!=1) c = '\n'; // "missing newline at end of file"

  if (c != '\n' && c != ';') {
    printf("unexpected character %c\n",c);
    delete cell;
    return 0;
  }

  if (m || c==';') {
    /* we have or need to have a multicell */
    if (m==0) {
      m = new Multicell();
      m->init();
    }
    
    m->addCell(cell);
    if (c==';') return readFrom(f,m); // load the rest of the line into m
    else return m; // last element of the multicell

  } else {
    /* savepoints on multicells are messy, so only accept them on
       single cells for the moment */
    cell->setSavePoint(savePoint,last=='l');
    return cell;
  }
}
