#ifndef CAR_H
#define CAR_H

class Car;

#include "camera.h"
#include "record.h"
#include "theme.h"
#include "glface.h"

class Car {
 public:
  Car();
  ~Car();
  bool init(float x,float y,float z,float angle);

  /* the array is copied */
  void setColour(float *rgb);
  /* DO NOT modify the returned array. That's what setColour is for. */
  float *getColour();

  /* controls */
  void engine(float d);
  void turn(float da);

  /* Writes the current position into the given vector. The same p is
     also returned, for convenience. */
  float *getPosition(float *p);

  /* Put the car at the given position */
  void setPosition(float *p);

  /* Put the car at the given position and angle */
  void put(float *p,float angle,float tilt);

  /* Accelerates the car by the given vector. This will only take
     effect for the next update() (so call it between each update()
     if this acceleration should be sustained) */
  void accelerate(float ax,float ay,float az);

  /* Saves the current position into the given record */
  //  void record(Record *record);

  /* returns the recorded trajectory of the car and starts recording a
     new trajectory. The returned pointer must be freed by the
     caller */
  Record *takeRecord();
  /* returns how long the current lap has been running */
  int getLapTime();

  void attachCamera(Camera *c);

  /* puts the camera into or next to the car, depending on the
     parameter. */
/*   void putCamera(); */
/*   void switchCamera(); */

  /* return value tells whether we just finished a lap. If zero is
     returned then we didn't, otherwise duration is returned */
  float update(float t);
  /* shows the speed etc on top of the screen */
  void renderinfo();
  void render(Theme *theme);

  /* meant for debugging.. This was called when space is pressed. */
  //  void jump();
 private:
  float x;
  float y;
  float z;
  float angle; //left right
  float tilt;  //forward / backward

  float rgb[3];

  float dangle; // "delta angle"
  float speedx;
  float speedy;
  float speedz;

  float hspeed; // (a hack)

  float accelx;
  float accely;
  float accelz;

  float eng; // whether engine is running
  float turning; // whether user is trying to turn

  Camera *camera;

/*   int camera; // which camera is currently selected (See CAM_* above) */
/*   float camangle; // smoothly follows angle */

  int spid; // [latest] save point id
  int savepoint[2]; // the x-z coordinates of the latest visited save
		    // point
  float savedHeight; // height at savepoint
  float savedAngle; // angle at savepoint

  /* The "now"-deadline after which we're no longer allowed to roll on
     the floor. If zero, there's no deadline. This is checked and set
     when we hit the floor, and reset when we drive on the track. If
     this deadline is crossed then we're sent back to the latest
     visited save point. */
  float floordl;

/*   float flyTime; */

  /* for debugging - that's the latest returned array from a
     cell->checkWall() */
/*   float normal[3]; */

  int lap;
  /* at what time the current lap started */
  float lapstart;
  Record *record;
  /* true if the next update() should reset the record */
  bool rerecord;

  /* object for rendering */
  FaceList *model;
};


#endif
