#include <math.h>

#include "car.h"
#include "main.h"
#include "cell.h"

/* dxf loader includes follow */
#include "faccess.h"
#include "globj.h"
#include "glface.h"


Car::Car() {record = 0;model = 0;}

Car::~Car() {
  if (record)
    delete record;

  if (model) delete model;
}

bool Car::init(float x,float y,float z,float angle) {
  int xf = (int)floorf(x);
  int zf = (int)floorf(z);

  this->x = x; this->y = y; this->z = z;
  this->rgb[0] = 0; this->rgb[1] = 0; this->rgb[2] = 1;
  this->angle = angle;
  this->tilt = 0;
  this->dangle = 0;
  this->turning = 0;
  this->speedx = 0; this->speedy = 0; this->speedz = 0;
  this->hspeed = 0;
  this->accelx = 0; this->accely = 0; this->accelz = 0;
  this->eng = 0;
  this->camera = 0;
  //  this->camangle = angle;
  this->floordl = 0;
  //  this->flyTime = 0;

  this->savepoint[0] = xf;
  this->savepoint[1] = zf;
  this->savedHeight = y;
  this->savedAngle = angle;
  this->spid = 1; // *not* zero, so that it won't look like we finished a lap right away

  this->lap = 0;
  this->lapstart = now;

  if (!record) {
    record = new Record();
    record->init();
  }
  record->reset(); // this line is useful for subsequent init()s
  rerecord = false;

  /* Load dxf object (I'm not sure about the legal status of said Dragfly.dxf, so I removed it from the archive and disabled this loading code) */
  // FileAccess FileObj( "models/Dragfly.dxf" );

  // if (FileObj.FileOK()) {
  //   GL_object GL_Obj( &FileObj );
  //   model = GL_Obj.GL_GetFaceList();  // Get the DXF object
  // } else {
  //   printf("failed to load car model\n");
  //   return false;
  // }
  return true;
}

void Car::setColour(float *rgb) {
  this->rgb[0] = rgb[0];
  this->rgb[1] = rgb[1];
  this->rgb[2] = rgb[2];
}

float *Car::getColour() {
  return rgb;
}

void Car::engine(float d) {
  eng = d;
}

void Car::turn(float da) {
  turning = da;
}

float *Car::getPosition(float *p) {
  p[0] = x;
  p[1] = y;
  p[2] = z;
  return p;
}

void Car::setPosition(float *p) {
  this->x = p[0];
  this->y = p[1];
  this->z = p[2];
}

void Car::put(float *p,float angle,float tilt) {
//   printf("puting at %f %f %f (%f,%f)\n",p[0],p[1],p[2],angle,tilt);
  setPosition(p);
  this->angle = angle;
  this->tilt = tilt;
}

void Car::accelerate(float ax,float ay,float az) {
//   printf("speed %f accel %f daccel %f\n",speedy,accely,ay);
  accelx += ax;
  accely += ay;
  accelz += az;
}

Record *Car::takeRecord() {
  Record *r = record;
  record = new Record();
  record->init();
  return r;
}

int Car::getLapTime() {
  return now-lapstart;
}

void Car::attachCamera(Camera *c) {
  this->camera = c;
  this->camera->follow(x,y,z,angle,tilt,true,true);
}

float Car::update(float t) {
  float p[3];

  /* Over three hundred lines of code to move a pointlike object in a
     constant gravitional field. Yay! */
  int sp=0; // this will be set as specified by Cell::isSavePoint()
  bool contact = false;
  bool reseted = false; // to be used for camera::follow
  //  bool doAngle = false;
  //  printf("%f ms\n",t);

  if (rerecord) {
    record->reset();
    rerecord = false;
  }

//   printf("%.3f: [%.3f,%.3f,%.3f] + [%.3f,%.3f,%.3f] ",t,x,y,z,speedx,speedy,speedz);

  /** Tell the current cell we are on it */
  track.getCell((int)floorf(x),(int)floorf(z))->interact(this,t);

  /* Environment before moving */
  float x0=x;
  float y0=y;
  float z0=z;

//   float tr = c->height(x-xf,y,z-zf); // track height
//   float *n = c->normal(x-xf,y,z-zf); // normal vector

//    printf("pre:%f, %f, %f...",x,y,z);

//     nrml[0] = n[0];
//     nrml[1] = n[1];
//     nrml[2] = n[2];

//   printf("\n");

//   printf("acceleration %f %f %f\n",accelx,accely,accelz);

  /* Apply gravity and accelerate */
  speedx += accelx*t;
  speedy += accely*t;
  speedz += accelz*t;

  accelx = 0; accely = -GRAVITY; accelz = 0;

  /* Friction */
  speedx *=1-t/INERTIA;
  speedy *=1-t/INERTIA;
  speedz *=1-t/INERTIA;

  /* Motion */
  x += speedx*t;
  y += speedy*t;
  z += speedz*t;

  /* now compute the angles. */
  //  if (doAngle) {
  if (hypotf(speedx,speedz)>0.01f) {
      /* We always look in the direction we're going (or the reverse
	 direction) unless we're not moving */

      /* first see if we're going forwards or backwards */
      // (there's probably a simpler way)
      hspeed = speedx*cosf(angle) + speedz*sinf(angle);

      angle = atan2f(speedz,speedx);
      if (hspeed<0) angle += PI;

  }

//   int xf = (int)floorf(x);
//   int zf = (int)floorf(z);

//   Cell *c = track.getCell(xf,zf);
//   float tr = c->height(x-xf,z-zf);
  //  printf("tr %.3f\n",tr);

  /* Post motion environment */
  int xf = (int)floorf(x);
  int zf = (int)floorf(z);
  Cell *c = track.getCell(xf,zf);
  float tr = c->height(x-xf,y,z-zf); // track height
  //  float *n2 = c->normal(x-xf,y,z-zf); (got replaced by "wall")

//   printf("post:%f, %f/%f, %f...",x,y,tr,z);

      //  }

  float dirx = cosf(angle); // what direction we're facing..
  float dirz = sinf(angle); // .. on the horizontal plane
  float speedh = speedx*dirx + speedz*dirz; // our speed wrt that direction

  /* collision handling */
  if (tr>y-0.5f) {
    float *wall = c->checkWall(x0-xf,y0,z0-zf,x-xf,y,z-zf);
//     normal[0] = wall[0];
//     normal[1] = wall[1];
//     normal[2] = wall[2];
    if (wall) {
      /* if we're here (rule made on-the-spot: checkWall should never
	 return null) then we're either below the ground or very close
	 to it. So engines work, savepoints get registered and stuff. */

//       printf("collision: tr %f, normal %f %f %f\n",tr,wall[0],wall[1],wall[2]);
      if (tr>y && wall[1] <= 0.05f) {
	/* if we're here we're below the ground and hit a vertical
	   wall. So go back to previous point and flip the speed
	   vector. */
// 	printf("horizontal shock n:[%f %f %f] ",wall[0],wall[1],wall[2]);
	/* Horizontal shock. */
	// scalar product. We're reflecting along the wall's normal vector
	float noise = wall[0]*speedx + wall[1]*speedy + wall[2]*speedz;
	x = x0;
	y = y0;
	z = z0;
	xf = (int)floorf(x);
	zf = (int)floorf(z);
//  	printf("s:[%f %f %f] ",speedx,speedy,speedz);
	speedx -= 2*wall[0]*noise;//-speedx;
	speedy -= 2*wall[1]*noise;
	speedz -= 2*wall[2]*noise;
//  	printf("|-> [%f %f %f]",speedx,speedy,speedz);
      } else {
	/* Vertical shock */
//  	printf("vertical shock.");
	if (y<tr) {
	  y = tr; // put the car back on the road
	  float s = 1.5f*(speedx*wall[0] + speedy*wall[1] + speedz*wall[2]); //scalar product
	  // 	printf("normal %.3f %.3f %.3f scalar %.3f",wall[0],wall[1],wall[2],s);
	  speedx -= s* wall[0]; /* used to multiply by 2, and then by 1.5f...) */
	  speedy -= s* wall[1];
	  speedz -= s* wall[2];
	  
	  /* We prevent the car from sliding by projecting the speed
	     vector in the direction we're facing */
	  s = speedx*dirx + speedz*dirz;
	  speedx = s*dirx;
	  speedz = s*dirz;
	}
	/* save point handling */
	if (tr == 0) {
	  // we hit the floor.
	  if (floordl>0 && now>floordl) {
	    /* restore latest save point */
	    //	  printf("loading %d %d %f\n",savepoint[0],savepoint[1],savedAngle);
	    xf = savepoint[0];
	    zf = savepoint[1];
	    c = track.getCell(xf,zf);

	    /* reset in the middle of the cell, just above the track */
	    x = xf+0.5f;
	    y = savedHeight; // c->height(0.5f,0,0.5f)+1;
	    z = zf+0.5f;
	  
	    //	  n2 = c2->normal(0.5f,0,0.5f);

	    speedx = 0;
	    speedy = 0;
	    speedz = 0;

	    angle = savedAngle;
	    //	  camangle = angle;
	    dangle = 0;
	    tilt = 0;

	    floordl = 0;
	    reseted = true;
	  } else if (floordl==0) {
	    floordl = now+FLOORDL;
	  }
	} else {
	  floordl = 0;
	  sp = c->isSavePoint(&spid);
	  if (sp>0) {
	    //	    printf("saving %d (%d) (%d %d %f)\n",sp,spid,xf,zf,angle);
	    savepoint[0] = xf;
	    savedHeight = y;
	    savepoint[1] = zf;
	    savedAngle = angle;
	  }
	}

	/* Engine handling */
	//    flyTime=0;
	if (eng!=0 && wall[1] > 0.05f) {
	  /* make the engine work */
	  //      printf("accelerating\n");
	  /* we set an acceleration vector as the projection of the view
	     vector [xa,0,za] (direction faced by the car) onto the
	     track, along the vertical axis. In other words we want to
	     find out ya such that [xa,ya,za][n0,n1,n2]=0, where n is
	     the normal vector and  is the scalar product */
      
	  float xa,ya,za,ta;
	  /*      if (fabsf(hspeed)>0.01f) {
		  xa = speedx*eng;
		  za = speedz*eng;
		  if (hspeed<0) {xa = -xa;za = -za;}
		  } else {*/
	  xa = cosf(angle)*eng;
	  za = sinf(angle)*eng;

	  ya = -(wall[0]*xa+wall[2]*za)/wall[1];

	  /* normalise the acceleration vector */

	  ta = hypot(xa,hypot(ya,za))/POWER;

	  //      }
	  accelx += xa/ta;
// 	  printf("[engine] accely = %f + %f/%f:",accely,ya,ta);
	  accely += ya/ta;
// 	  printf("%f\n",accely);

	  accelz += za/ta;

	  //       float h = n[0]*xa + n[2]*za; // scalar product
      
	  //       float na[3];
	  //       na[0] = xa-n[0]*h;
	  //       na[1] =   -n[1]*h;
	  //       na[2] = za-n[2]*h;
	  //       float l = sqrtf(sq(na[0])+sq(na[1])+sq(na[2]))/POWER;

	  //       accelx += na[0]/l;
	  //       accely += na[1]/l;
	  //       accelz += na[2]/l;
	}

	// printf("%f",angle);

	/* update dangle. Note, this is the turning *request* from the
	   user, not the actual rotation, which depends on our speed */
	dangle *= 1-t/(RINERTIA); // slow down turning
	if (turning!=0) dangle += t*turning*RPOWER;

	if (fabsf(speedx)>0.0001f || fabsf(speedz)>0.0001f) {

	  if (fabsf(dangle)>0.0001f) {
	    /* The vector product of wherever we're going
	       (speedx,speedy,speedz) and the surface's normal vector (na)
	       gives "our" right, i.e.~where we must accelerate when turning
	       right. We're *not* normalising so the centripetal
	       acceleration is proportional to the speed */
      
	    accelx += (speedy*wall[2]-speedz*wall[1])*dangle;
	    accely += (speedz*wall[0]-speedx*wall[2])*dangle;
	    accelz += (speedx*wall[1]-speedy*wall[0])*dangle;

// 	    printf("[turning] -> %f\n",accely);

	    /* this has no effects whatsoever (?) */
	    //	doAngle = true;
	  }
	}
	//   }


	//  float h=hypotf(speedx,speedz); // horizontal speed
	/* align ourselves to the track */
	float nh = dirx*wall[0] + dirz*wall[2]; // normal projected in our direction
	float tilt2 = atan2f(wall[1],nh)-HALFPI;
	tilt = tilt*0.9f + tilt2*0.1f;

      }
    }
    //  }
    contact = true;
  } else if (fabsf(speedh)>0.02f) {
    /* compute tilt when flying */
    float factor = fabsf(speedh)/20;
    if (factor>0.4f) factor=0.4f;
    float tilt2 = atanf(speedy/speedh);
    tilt = tilt*(1-factor) + tilt2*factor;
    //    printf("%f,%f,%f -> %f,%f -> %.3f\n",speedx,speedy,speedz,h,speedy,tilt);
  }
//   printf("\n");

  if (camera) {
    camera->follow(x,y,z,angle,tilt,!contact,reseted);
  }

  record->record(getPosition(p),angle,tilt,now-lapstart);

  if (sp==3) {
    float lt = now-lapstart;
    lap++;
    lapstart = now;
    rerecord = true;
    /* we give the caller a chance to use our record before erasing
       it, at next udpate() ... */
    return lt;
  } else return 0;
}

// void Car::jump() {
//   speedy += 0.1f;
// }

void Car::renderinfo() {
  float s = hypotf(speedx,hypot(speedy,speedz))*3;
  glPushMatrix(); {
    glBegin(GL_LINES);
    glColor3f(1,1,1);
    glVertex3f(-0.4f,          0.8f,          -2);
    glVertex3f(-0.4f+cosf(4-s)/5,0.8f+sinf(4-s)/5,-2);
    glEnd();
  
    glPushMatrix(); {
      glTranslatef(-0.35f,0.7f,-2);
      glScalef(0.02f,0.02f,0.02f);
      printNumber((int)(s*50),2);
    } glPopMatrix();

    glTranslatef(0.6f,0.9f,-2);
    glScalef(0.04f,0.04f,0.04f);
    printNumber(lap,1);
    
  } glPopMatrix();

  glPushMatrix(); {
    glTranslatef(0.6f,0.8f,-2);
    glScalef(0.04f,0.04f,0.04f);
    printTime(now-lapstart);
  } glPopMatrix();
}


/** Display one polygon of a dxf object */
void disp_gl_face(FaceList::face *face_ptr )
{
  int NumPts = face_ptr->point_cnt;
  static int layer=0;
  bool positive = true;
//   printf("%d",face_ptr->colornum);
  if (layer != face_ptr->colornum) {
    if (layer==10 || layer==16) glPopMatrix();
    layer = face_ptr->colornum;
    switch (layer) {
    case 2: // tail
      glColor3f(0.6f,0.2f,0);
      break;
    case 8: // head
      glColor3fv(olive);
      break;
    case 15: // abdomen
      glColor3fv(darkred);
      break;
    case 10: case 16: // wings

      glColor4f(0,0.4f,0.1f,0.5f);
      glPushMatrix();
      glRotatef(sin(now/100.0f)*25,0,1,0);
      positive=true;
      break;
      // 10 are the back wings (yes, both of them :/ )
      // 16 are the forward wings.
    case 13: // eyes
      glColor3fv(pistacchio);
      break;
    default:
      glColor3fv(greenblue);
      break;
    }
  }

  if ((layer==10 || layer==16) && positive && face_ptr->f[0].v[0]<0) {
    /* we enter this when switching from a right wing to a left wing */
    glPopMatrix();
    glPushMatrix();
    glRotatef(-sin(now/100.0f)*25,0,1,0);
    positive = false;
  }

  glBegin( GL_POLYGON );
  glNormal3fv(face_ptr->normal);
  for (int i = 0; i < NumPts; i++) {
//     if (face_ptr->colornum==10 || face_ptr->colornum==16)
//       printf(face_ptr->f[i].v[0]<0?"-":"+");
    glVertex3fv(face_ptr->f[i].v);
  }
  glEnd();
//   printf("\n");
}

void Car::render(Theme *theme) {
  if (camera) camera->render();
  glPushMatrix();
  glTranslatef(x,y,z);


  /* debug - that's the ground normal vector */
//    glBegin(GL_LINES);
//    glColor3f(1,1,1);
//    glVertex3f(0,0,0);
//    glVertex3fv(normal);
//    glEnd();


  glRotatef(90-(angle RADIANS),0,1,0);
  glRotatef(-tilt RADIANS,1,0,0);

  //glScalef(0.02f,0.02f,0.02f);
//   glTranslatef(0,2,0);
//   glRotatef(-90,1,0,0);

//   FaceList::ListHandle FaceList = model->GetListStart();
//   while (FaceList != NULL) {
//     disp_gl_face( model->GetFace(FaceList) );
//     FaceList = model->GetNextFace( FaceList );
//   }


     theme->car(rgb);

  glPopMatrix();
}
