#ifndef CAMERA_H
#define CAMERA_H

/** camera control code **/

class Camera {
 public:
  Camera();
  ~Camera();

  /** tell the camera to look at the given object. angle and tilt tell
      which way the object (*not* the camera) is facing.

      Set falling to true if the object being followed is falling (for
      cool camera effects).

      Set reset to true if the object just teleported to a new place
      (e.g. when being taken back to a save point, when restarting
      the game, etc) */
  void follow(float x,float y,float z,float angle,float tilt,bool falling,bool reset);

  /* Switch between camera mode, behind, top, side, etc */
  void switchMode();

  void update(float t);

  /** For debugging - this shows the current and next camera location */
  void render();

  void put();

 private:
  /* The object being looked at */
  float ox,oy,oz,oangle,otilt;
  bool falling;

  int mode;
  /* Camera position */
  float x,y,z;
  float speedy;
  float angle;

  float otilt2;

  /* debugging */
  float trace[12];

  /* How long we have been flying (if applicable) - this is used for
     camera effects. UPDATE - actually resetting it to zero would
     result in headache inducing camera jerks (at landing time) so it
     is a smoothened version of actual flytime */
  float flyTime;
};

#endif
