#include <math.h>

#include "camera.h"
#include "base.h"
#include "main.h"
#include "cell.h"

#define CAM_BEHIND 0
#define CAM_TOP 1
#define CAM_SIDE 2
/* the "experimental camera" */
#define CAM_EXP 3

#define LAST_CAM 3

Camera::Camera() {
  ox = 0; oy=0; oz=0; oangle=0; otilt=0; falling=false;

  mode = CAM_EXP;
  angle = 0;

  flyTime = 0;
}

Camera::~Camera() {}

void Camera::switchMode() {
  mode++;
  if (mode>LAST_CAM) mode=0;
}

void Camera::follow(float x,float y,float z,float angle,float tilt,bool falling,bool reset) {
  this->ox = x;
  this->oy = y;
  this->oz = z;
  this->oangle = angle;

  /* We override the car's angle when it is close to a Wheel: in that
     case, we pretend it is facing the wheel's axis so that camera
     will tend to face the wheel as well. */
  int xf = (int)floorf(x);
  int zf = (int)floorf(z);
  /* oh, actually let's go generic */
  float pref = angle;
  
  for (int dx=-1;dx<2;dx++) {
    for (int dz=-1;dz<2;dz++) {
      Cell *c = track.getCell(xf+dx,zf+dz);
      if (c->preferredAngle(&pref)) {
	float t = 1.5f-fmaxf(fabsf(x-(xf+dx+0.5f)),
			     fabsf(z-(zf+dz+0.5f)));
	if (t>1) t=1;

	/* make sure pref-angle is between -PI and +PI */
	pref -= TWOPI*floorf((pref-angle)/TWOPI+0.5f);

	this->oangle = angle*(1-t) + pref*t;
      }
    }
  }

  this->otilt = tilt;
  if  (this->falling && !falling) {
    speedy = 0; // make the user "feel" we just landed
  }
  this->falling = falling;

  if (reset) {
    this->x = ox;
    this->y = oy;
    this->z = oz;
    this->angle = angle;
  }
}

void Camera::put() {
  if (mode==CAM_EXP) {
    glRotatef(atan2f(y-oy,hypotf(z-oz,x-ox)) RADIANS-18,1,0,0);
    glRotatef(90+angle/* (atan2f(z-oz,x-ox)-PI/2)*/ RADIANS,0,1,0);
    glTranslatef(-x,-y,-z);
    return;
  }
  if (mode==CAM_TOP) {
    float h = 0;//150-75/(0.5f+hypot(speedx,speedz));
    glTranslatef(0,0,-3);
    glRotatef(90 - h,1,0,0);
    glRotatef(90 + angle RADIANS,0,1,0);
    glTranslatef(-ox,-oy,-oz);
    return;
  }
  if (mode==CAM_SIDE) {
    // glRotatef(-otilt RADIANS,1,0,0);
    glTranslatef(0,-0.5f,-2);
    glRotatef(angle RADIANS+180,0,1,0);
    glTranslatef(-ox,-oy,-oz);
    return;
  }
  if (mode==CAM_BEHIND) {
    glTranslatef(0,-0.5f,-1.2f);
    /* throw a hyperbolic tangent into camera motion equations and
       they instantly become awesome */
    float h = (tanh((flyTime-10)/10)+1)/2;
    //    printf("%f -> %f\n",flyTime,h);
    glTranslatef(0,0,-h*2);

    /* 0.8f: that's the angle towards which we converge in flight time */
    glRotatef(((-otilt+0.1f)*(1-h)+h*0.8f) RADIANS,1,0,0);
  /* 90+ because angle 0 is facing towards the x axis... */
    glRotatef(90+(angle RADIANS),0,1,0); 
  glTranslatef(-ox,-oy,-oz);
  }
}

void Camera::update(float t) {
    /* throw a hyperbolic tangent into camera motion equations and
       they instantly become awesome */
  float d = (tanh((flyTime-10)/10)+3);

  bool intrack=true;
  float tr,tr2;
  float x2,y2,z2;
  float dx,dy,dz;

  otilt2 = otilt-0.3f;

  while (intrack) {
    dx = d*cos(oangle)*cos(otilt2);
    dy = d*sin(otilt2);
    dz = d*sin(oangle)*cos(otilt2);

    /** Take the largest height in five points to make sure we aren't
	trying to look through a wall */
    tr2 = 0;
    for (int i=1;i<=5;i++) {
      tr2 = fmaxf(tr2,track.getHeight(ox-dx*i/5,oy-dy*i/5,oz-dz*i/5));
    }

    y2 = oy-dy;

    if (otilt2>-4 && y2<tr2+0.6f)
      otilt2 -= 0.001f;
    else {
      if (otilt2<=-4) printf("looped!!!\n");
      intrack = false;
    }
  }

  x2 = ox-dx;
  //  y2 = oy-dy;
  z2 = oz-dz;

//   otilt2 -= 0.2f;
//   x2 = ox-d*cos(oangle)*cos(otilt2);
//   y2 = oy-d*sin(otilt2);
//   z2 = oz-d*sin(oangle)*cos(otilt2);

  /* this is the point where we'd trying to put the camera */
//   x2 = ox-d*cos(oangle)*cos(otilt2);
//   y2 = oy-d*sin(otilt2);
//   z2 = oz-d*sin(oangle)*cos(otilt2);

  x = x*(1-t)+x2*t;

  /* camera gravity */
  if (speedy>0)
    speedy=0;
  else
    speedy -= t*GRAVITY*2;

  if (speedy < (y2-y))
    speedy = (y2-y);

  y += speedy*t;
  z = z*(1-t)+z2*t;

  /* make sure the camera isn't inside the track */
  tr = track.getHeight(x,y,z);

  //  printf("%f,%f/%f,%f -> %f,%f/%f,%f\n",x,y,tr,z,x2,y2,tr2,z2);

  if (y<tr+0.6f) y = tr+0.6f;


  if (falling) { // we're flyiiiiiiiiiing !!! :D
    flyTime += t;
  } else {
    flyTime *= 1-t/6;
  }
      
  if (oangle-angle>PI) angle += TWOPI;
  else if (angle-oangle>PI) angle -= TWOPI;
  
  angle = angle*(1-t)+oangle*t;
}

void Camera::render() {
}
