#ifndef BUTTON_H
#define BUTTON_H

#include "base.h"
#include "cell.h"

/** A button in the editor tool bar */

class Button {
 public:
  Button();
  ~Button();

  /** Will render() the given cell as button image. x and y are in
      opengl coordinates. rotate=true:show topdown, false:show from
      front */
  void init(float x,float y,Cell *img,bool rotate);

  void render();

  /** Pass all events to the button - true is returned if the button
      was clicked */
  bool event(SDL_Event *e);

  /* mark it as unselected */
  void release();

  /* Build a new instance of the attached cell */
  Cell *build();

 private:
  bool highlighted; // whether the mouse is on it
  bool selected; // whether it is selected
  float x;
  float y;
  bool rotate;
  Cell *img;
};

#endif
