#include "button.h"
#include "base.h"
#include "main.h"

Button::Button() {}
Button::~Button() {}

void Button::init(float x,float y,Cell *img,bool rotate) {
  this->x = x;
  this->y = y;
  this->img = img;
  this->rotate = rotate;
  highlighted=false;
  selected=false;
}

void Button::render() {
   glPushMatrix();
   glTranslatef(x,rotate?(-y):(-y-1),rotate?-20:-20.5f);

   if (rotate) glRotatef(90,1,0,0);
   img->render(plainTheme);
   if (!rotate) {
     glTranslatef(0,1,0.5f);
     glRotatef(90,1,0,0);
   }

   if (highlighted||selected)
     glColor3f(selected?1:0,0,highlighted?0.5f:0.0f);
   else
     glColor3f(1,1,1);
  glBegin((highlighted||selected)?GL_QUADS:GL_LINE_LOOP);
  glVertex3f(1,0,0);
  glVertex3f(0,0,0);
  glVertex3f(0,0,1);
  glVertex3f(1,0,1);
  glEnd();
  glPopMatrix();
}

bool Button::event(SDL_Event *e) {
  float mx,my;
  switch ( e->type ) {
  case SDL_MOUSEMOTION :
    mx = (e->motion.x-600+3600)/36.0f-100;
    my = (e->motion.y-360+3600)/36.0f-100;
    highlighted= (x<mx && mx<x+1 &&
		  y<my && my<y+1);
    return false;
  case SDL_MOUSEBUTTONDOWN:
    mx = (e->motion.x-600+3600)/36.0f-100;
    my = (e->motion.y-360+3600)/36.0f-100;
    if (x<mx && mx<x+1 &&
	y<my && my<y+1) {
      selected = true;
      return true;
    } else {
      return false;
    }
  }
  return false;
}

void Button::release() {
  selected = false;
}

Cell *Button::build() {
  return img->clone();
}
