#include <math.h>
#include "main.h"
#include "bouncing.h"

Bouncing::Bouncing() {}
Bouncing::~Bouncing() {}

bool Bouncing::init(int angle,float amplitude,float freq,float hei) {
  Straight::init(angle,0,hei);
  this->amplitude = amplitude;
  this->freq = freq;
  return true;
}

float Bouncing::height0() {
  return hei+sinf(now/freq)*amplitude;
}

void Bouncing::render(Theme *theme) {
  render0(height0());
}

void Bouncing::writeTo(FILE *f) {
  prefixTo(f);
  fprintf(f," b %d %f %f %f %c%c",angle,amplitude,freq,hei,starting?'[':'-',ending?']':'-');
}

bool Bouncing::initFrom(FILE *f) {
  int a;
  float amp,frq,h;
  char bs,be;
  int n = fscanf(f," %d %f %f %f %c%c",&a,&amp,&frq,&h,&bs,&be);
  if (n<6) {
    printf("found %d items, expected 6\n",n);
    return false;
  }
  if (!init(a,amp,frq,h)) return false;
  starting= (bs=='[');
  ending= (be==']');
  return true;
}
