#include <math.h>

//#include "ball.h"

#include "main.h"
//#include "editor.h"
//#include "trails.h"
#include "record.h"
#include "controller.h"

bool twoplay;

int ptime; // total time the game has been paused
int prev;
int now;
int laptime;

//float red[] = {1,0,0};
Car player1,player2;
Camera cam1,cam2;

Car othercar; // best time so far
Record *bestRecord;

Controller cntr1,cntr2;

void reset() {
  int startx,startz;
  float starty;
  ptime = SDL_GetTicks();
  prev=0;
  now=0;

  track.getStartPoint(&startx,&starty,&startz);
  if (twoplay) {
    player1.init(startx+0.5f,starty,startz+0.4f,0);
    player2.init(startx+0.5f,starty,startz+0.6f,0);
    player2.setColour(red);
  } else {
    player1.init(startx+0.5f,starty,startz+0.5f,0);
  }
  player1.attachCamera(&cam1);
  player2.attachCamera(&cam2);
}

void setPerspective() {
  glMatrixMode(GL_PROJECTION);                        // Select The Projection Matrix
  glLoadIdentity();                                   // Reset The Projection Matrix
  glPerspective( 45.0f, (GLfloat)SCREEN_WIDTH/(twoplay?2:1)/(GLfloat)SCREEN_HEIGHT, 1.0f, 10000.0f );
  glMatrixMode(GL_MODELVIEW);
}

void render(Car *player,Camera *camera) {
  float lightPos[] = {0.3f,1.0f,1.0f,0};

  glLoadIdentity();
  
  camera->put();
  
  glLightfv( GL_LIGHT0,GL_POSITION,lightPos);
  
  track.render();
  //    if (doTrail) toy.render();
  player1.render(track.getTheme());
  if (twoplay) player2.render(track.getTheme());
  if (bestRecord) {
    bestRecord->putCar(&othercar,twoplay?now:player1.getLapTime());
    othercar.render(track.getTheme());
  }

  /* now put the info at the top */
  glLoadIdentity();
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);

  player->renderinfo();
  if (laptime) {
    glPushMatrix();
    glColor3f(1,0,0);
    glTranslatef(0.6f,0.7f,-2);
    glScalef(0.04f,0.04f,0.04f);
    printTime(laptime);
    glPopMatrix();
  }
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_LIGHTING);

}

void setViewPort(int x,int y,int w,int h) {

    glViewport(x,y,w,h);
}

void body() {
  bool done=false;
  bool paused=false;

  /* For debugging. Will pause the game at next frame to enable frame
     by frame viewing. */
  bool step=false;

  int psince = 0; // when paused, SDL_Ticks at time paused got activated
  laptime = 0;
  SDL_Event event;

  int w = twoplay?SCREEN_WIDTH/2:SCREEN_WIDTH;
  int h = SCREEN_HEIGHT;
  setPerspective();

  reset();
  now = SDL_GetTicks();
  if (twoplay) {
    cntr1.attach(&player1,&cam1,SDLK_e,SDLK_t,SDLK_4,SDLK_r,SDLK_c);
    cntr2.attach(&player2,&cam2,SDLK_LEFT,SDLK_RIGHT,SDLK_UP,SDLK_DOWN,SDLK_v);

  } else {
    cntr1.attach(&player1,&cam1,SDLK_LEFT,SDLK_RIGHT,SDLK_UP,SDLK_DOWN,SDLK_v);
  }

  bestRecord = 0;
  othercar.init(0,0,0,0);

//   Trails toy; float carp[3]; bool doTrail=false;
//   toy.init(2000);

  //  Ball ball;

  while (!done) {
    if (!paused) prev=now;
    SDL_WaitEvent(0);
    if (!paused)  now=SDL_GetTicks()-ptime;

    if (step) {
      psince = SDL_GetTicks();
      paused = true;
      step = false;
    }

    while( SDL_PollEvent(& event) )
      {
//  	if (event.type == SDL_KEYDOWN || event.type == SDL_KEYUP) {
//  	  printf("key event: %s %d\n",(event.type==SDL_KEYUP?"up":"down"),event.key.keysym.sym);
//  	}

	if (!(cntr1.event(event) || cntr2.event(event))) {

	switch ( event.type )
	  {
	  case SDL_QUIT :
	    done=true;
  	  case SDL_KEYDOWN :           
	    switch (event.key.keysym.sym) {
	    case SDLK_w:
	      editor();
	      setPerspective();
	      // break;
	    case SDLK_ESCAPE:
	      reset();
	      break;

	    case SDLK_F1:
	      menu();
	      setPerspective();
	      reset();
	      break;

	    case SDLK_p:
	      if (paused) {
		ptime += SDL_GetTicks()-psince;
		paused = false;
	      } else {
		psince = SDL_GetTicks();
		paused = true;
	      }
	      step=false;
	      break;
	    case SDLK_PERIOD:
	      if (paused) {
		ptime += SDL_GetTicks()-psince;
		paused = false;
	      }
	      step = true;
	      break;
	    case SDLK_q:
	      done = true;
	      break;
	    default:
	      break;
	    }
 	    break;
	  }
	}
      }

    /* update things */

    //    printf("%d (%d) ",now,now-prev);

    float dt =   (now-prev) / 100.0f;
    if (dt>0.3f) dt = 0.3f; // slow down simulation on slow computers...

    if (!paused) {
      cam1.update(dt);
      float lt = player1.update(dt);
      if (lt>0) {
	if (laptime==0 || laptime>lt) {
	  laptime = lt;
	  if (bestRecord) delete bestRecord;
	  bestRecord = player1.takeRecord();
	  othercar.setColour(player1.getColour());
	}
      }
      if (twoplay) {
	cam2.update(dt);
	lt = player2.update(dt);
	if (lt>0) {
	  if (laptime==0 || laptime>lt) {
	    laptime = lt;
	    if (bestRecord) delete bestRecord;
	    bestRecord = player2.takeRecord();
	    othercar.setColour(player2.getColour());
	  }
	}
      }
//       car.getPosition(carp);
      //      toy.record(carp);

    }

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer

    setViewPort(0,0,w,h);
    render(&player1,&cam1);
    if (twoplay) {
      setViewPort(w,0,w,h);
      render(&player2,&cam2);
    }
    SDL_GL_SwapBuffers(); 

  }
}
