cc = g++

######### INCLUDES ###########################

INCLUDE  = -I. -I/usr/include

######### LIBRARIES  #########################
# -lXmu -lX11
# LIBS =  -L${GLUT_DIR}/lib -lGLU -lGL -lglut -lm -lc -lSDL -ljpeg -lfreetype -lopenal -logg -lvorbis -lvorbisfile
LIBS =  -L${GLUT_DIR}/lib  -lc -lGL -lGLU -ljpeg -lm -lpng -lSDL

######### FLAGS      #########################
# (what are valid -march options?)
CXXFLAGS   = $(INCLUDE) -Wall -O3 -fomit-frame-pointer -x c++ 
# CXXFLAGS   = $(INCLUDE) -Wall -g -x c++ 

######### OBJECTS    #########################

#COBJ = $(CSRC:.cpp=.o)

allobjs: objs
	for sd in $(SUBDIR); do $(MAKE) -C $$sd allobjs; done

objs: ${COBJ}

obj-list:
	for sd in $(SUBDIR); do export DIR += /$$sd; $(MAKE) -C $$sd obj-list; done
	echo -n "${COBJ} "

#####  RULES  ####
.SUFFIXES : .cpp .c

.cpp.o :	
	$(cc)  ${CXXFLAGS} -c $<



###--------------###
###    Clean     ###
###--------------###

clean :
	-rm -f  $(COBJ)
	-rm -rf ii_files

cleanall: clean
	for sd in $(SUBDIR); do $(MAKE) -C $$sd cleanall; done


depend:
	@echo ""
	@echo " *** UPDATING DEPENDENCIES... ***"
	@(sed '/^# DO NOT DELETE THIS LINE/q' Makefile && \
	  $(cc) -M ${CSRC} | \
          egrep -v "/usr/include" | egrep -v "/usr/local/pub" | sort -u \
	 ) >Makefile.new
	@cp Makefile Makefile.BAK
	@cp Makefile.new Makefile
	@rm -f Makefile.new
