#include "vanish.h"
#include "base.h"
#include "main.h"

Vanish::Vanish() {}

void Vanish::update() {
  Domino::update();
  if (abs(angle)>=4) {
    cell->leave(top);
    angle=0;speed=0;fly=0;
  }
}

void Vanish::render(float t) {
  /* process push()es */
  //  printf("%d + %d + %d\n",accel,speed,angle);
  if (accel!=0) speed=accel;
  accel=0;

  glPushMatrix();

  rot(t);

  if (renderBroken(t)) {

    glScalef(1,0.2f,1);

    int g=1; // green component
    for (int i=0;i<5;i++) {

      glColor3f(1,g,0);
      glBegin(GL_QUADS);
      glNormal3f( 0,0, 1);
      glVertex3f(-DOMWID,0, 2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,0, 2);
      
      glNormal3f( 1,0, 0);
      glVertex3f( DOMWID,0, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f( DOMWID,0,-2);
      
      glNormal3f( 0,0,-1);
      glVertex3f( DOMWID,0,-2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,0,-2);
      
      glNormal3f(-1,0, 0);
      glVertex3f(-DOMWID,0,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f(-DOMWID,0, 2);
      glEnd();
      
      glTranslatef(0,DOMHEI,0);
      g = 1-g;
    }
  }

  glPopMatrix();
}

Vanish::~Vanish() {

}


