#include "trigger.h"
#include "base.h"
#include "main.h"

Trigger::Trigger() {}

void Trigger::land() {
  speed=0;
  level->openWayOut();
}

void Trigger::render(float t) {
  /* process push()es */
  //  printf("%d + %d + %d\n",accel,speed,angle);
  if (accel!=0) speed=accel;
  accel=0;

  glPushMatrix();

  rot(t);

  if (renderBroken(t)) {


    glBegin(GL_QUADS);
    glColor3f(1,1,0);
    glNormal3f(0,1,0); // top
    glVertex3f(-DOMWID,DOMHEI,-2);
    glVertex3f( DOMWID,DOMHEI,-2);
    glVertex3f( DOMWID,DOMHEI,2);
    glVertex3f(-DOMWID,DOMHEI,2);

    glNormal3f(0,-1,0); // bottom
    glVertex3f(-DOMWID,0,-2);
    glVertex3f( DOMWID,0,-2);
    glVertex3f( DOMWID,0, 2);
    glVertex3f(-DOMWID,0, 2);
    glEnd();

    glScalef(1,1/7.0f,1);

    int g=1; // green component
    for (int i=0;i<7;i++) {

      glColor3f(1,g,0);
      glBegin(GL_QUADS);
      glNormal3f( 0,0, 1);
      glVertex3f(-DOMWID,0, 2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,0, 2);
      
      glNormal3f( 1,0, 0);
      glVertex3f( DOMWID,0, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f( DOMWID,0,-2);
      
      glNormal3f( 0,0,-1);
      glVertex3f( DOMWID,0,-2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,0,-2);
      
      glNormal3f(-1,0, 0);
      glVertex3f(-DOMWID,0,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f(-DOMWID,0, 2);
      glEnd();
      
      glTranslatef(0,DOMHEI,0);
      g = 1-g;
    }
  }

  glPopMatrix();
}

Trigger::~Trigger() {

}


