/* $Id: tools_glPerspective.cpp,v 1.1 2004/03/26 07:24:21 baloo Exp $ */

#include <math.h>

#include "tools.h"


/**
 *	Replaces gluPerspective, sets the frustum to perspective mode.
 *	@param fovY	  : Field of vision in degrees in the y direction
 *	@param aspect : Aspect ratio of the viewport
 *	@param zNear  : The near clipping distance
 *	@param zFar	  : The far clipping distance
 */
void glPerspective( GLdouble fovY, GLdouble aspect, GLdouble zNear, GLdouble zFar )
{
	//	Very long (& in theory accurate!) version of Pi. Hopefully an optimizing compiler
	//	will replace references to this with the value!
	const GLdouble pi = 3.1415926535897932384626433832795;

	//	Half of the size of the x and y clipping planes.
	GLdouble fW, fH;

	//	Calculate the distance from 0 of the y clipping plane. Basically trig to calculate
	//	position of clipper at zNear.

	//	Note:	tan( double ) uses radians but OpenGL works in degrees so we convert
	//			degrees to radians by deviding by 180 then multiplying by pi.
	fH = tan( fovY / 180 * pi ) * zNear / 2;

	//	Calculate the distance from 0 of the x clipping plane based on the aspect ratio.
	fW = fH * aspect;

	//	Finally call glFrustum, this is all gluPerspective does anyway!
	//	This is why we calculate half the distance between the clipping planes - glFrustum
	//	takes an offset from zero for each clipping planes distance. (Saves 2 divides)
	glFrustum( -fW, fW, -fH, fH, zNear, zFar );
}
