#include "splitter.h"
#include "main.h"

Splitter::Splitter() {}
Splitter::~Splitter() {}

void Splitter::init(Cell *c) {
  angle2=0; speed2=0; accel2=0;
  Domino::init(c);
}

bool Splitter::swap() {
  if (angle!=angle2 || speed!=speed2 || accel!=accel2) {
    int oangle=angle;int ospeed=speed;int oaccel=accel;
    angle=angle2;
    speed=speed2;
    accel=accel2;
    angle2=oangle;
    speed2=ospeed;
    accel2=oaccel;
    return true;
  } else return false;
}

bool Splitter::touch(int direction) {
  if (Domino::touch(direction))
    return true;
  else {
    swap();
    bool ret= (Domino::touch(direction));
    swap();
    return ret;
  }
}

bool Splitter::push(int direction,int from) {
  // printf("splitter pushed %d %d\n",direction,from);
  if (angle==0 && angle2==0 && speed==0 && speed2==0) {
    // printf("splitting\n");
    /* when we're at rest, pushing us will actually generate opposing
       pushes on the two halves (resulting in a split if there's
       contact) **/
  // printf("1:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
    bool ret = Domino::push(direction,from);
  // printf("1p:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
    swap();
  // printf("2:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
    ret = Domino::push(-direction,from) && ret;
  // printf("2p:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
    swap();
  // printf("back:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
    return ret;
  } else {
    /* Otherwise, act on both halves independently, in the same way */
    bool ret = Domino::push(direction,from);
    swap();
    ret = Domino::push(direction,from) && ret;
    swap();
    return ret;
  }
}

void Splitter::boom() {
  /* if something falls on a splitter, we split it */
  push(1,0);
}

void Splitter::update() {
  // printf("pre-up:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
  Domino::update();
  swap();
  Domino::update();
  swap();
  // printf("post-up:%d+%d+%d/%d+%d+%d\n",angle,speed,accel,angle2,speed2,accel2);
}

void Splitter::render(float t) {
  bool first=true; // first pass (half)
  
  do {

    /* process push()es */
    //  printf("%d + %d + %d\n",accel,speed,angle);
    if (accel!=0) {
      speed=accel;
    }
    accel=0;

    glPushMatrix();

    rot(t);

    if (renderBroken(t)) {

      glBegin(GL_QUADS);
      glColor3f(1,1,0);
      glNormal3f(0,1,0); // top
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f( DOMWID,DOMHEI,2);
      glVertex3f(-DOMWID,DOMHEI,2);

      glColor3f(1,0,0);
      glNormal3f(0,-1,0); // bottom
      glVertex3f(-DOMWID,0,-2);
      glVertex3f( DOMWID,0,-2);
      glVertex3f( DOMWID,0, 2);
      glVertex3f(-DOMWID,0, 2);
      glEnd();

      glScalef(1,0.5f,1);

      int g=0; // green component
      for (int i=0;i<2;i++) {

	glColor3f(1,g,0);
	glBegin(GL_QUADS);
	glNormal3f( 0,0, 1);
	glVertex3f(-DOMWID,0, 2);
	glVertex3f(-DOMWID,DOMHEI, 2);
	glVertex3f( DOMWID,DOMHEI, 2);
	glVertex3f( DOMWID,0, 2);
      
	glNormal3f( 1,0, 0);
	glVertex3f( DOMWID,0, 2);
	glVertex3f( DOMWID,DOMHEI, 2);
	glVertex3f( DOMWID,DOMHEI,-2);
	glVertex3f( DOMWID,0,-2);
      
	glNormal3f( 0,0,-1);
	glVertex3f( DOMWID,0,-2);
	glVertex3f( DOMWID,DOMHEI,-2);
	glVertex3f(-DOMWID,DOMHEI,-2);
	glVertex3f(-DOMWID,0,-2);
      
	glNormal3f(-1,0, 0);
	glVertex3f(-DOMWID,0,-2);
	glVertex3f(-DOMWID,DOMHEI,-2);
	glVertex3f(-DOMWID,DOMHEI, 2);
	glVertex3f(-DOMWID,0, 2);
	glEnd();
      
	glTranslatef(0,DOMHEI,0);
	g = 1-g;
      }
    }

    glPopMatrix();

    if (swap() && first)
      first=false;
    else return;
  } while (1);
}
