#ifndef PLAYER_H
#define PLAYER_H

class Player;

#include "cell.h"

class Player {
 public:

  Player();
  ~Player();

  void init(Cell *cell);

  void render(float t);

  /* returns whether we're still alive */
  bool update();

  void move(int direction);
  void climb(int direction);
  void push(int direction);
  void stop();
  /* Try to grab a domino. If a domino was already being held, then it
     will be released instead. Returns true if action was taken. */
  bool grab();

  Cell *getCell(int dy=0);

 private:
  
  /* in Cell coordinates */
  int x;
  int y;

  bool stopping;
  bool falling;
  bool releasing;

  /* -1 if the back foot (away from the camera) points forward (at the
     beginning of the generation), +1 if its the front foot */
  int foot;

  int speed;

  int vspeed;
  
  int z; // <0 when leaving/entering the game
  int deltaZ;

  /* If the played is holding a domino, here it is */
  Domino *held;

  /* Passed to normCam (it jumps up when the user moves, gradually
  drops to 0 the rest of the time) */
  int importance;
  /* when the player stops moving, importance remains maxed out for a
     few generations, before decreasing. This is timer for that */
  int implatency;
};

#endif
