#include "player.h"
#include "main.h"
#include <math.h>

#define STEPS 8

Player::Player() {}
Player::~Player() {}

void Player::init(Cell *cell) {
  this->x = cell->getX()*STEPS;
  this->y = cell->getY()*STEPS;
  z=-9;
  deltaZ=1;
  speed = 0;
  stopping = false;
  falling = false;
  vspeed = 0;
  held = 0;
  importance = 1;
  implatency = 0;
  foot=-1;
}

/* draws a cylinder from (0,0,0) to (0,len,0) */
void cylinder(float len) {
  glBegin(GL_QUAD_STRIP);
  glNormal3f(1,0,0);
  glVertex3f(0.1f,0,0);
  glVertex3f(0.1f,len,0);

  glNormal3f(0,0,1);
  glVertex3f(0,0,0.1f);
  glVertex3f(0,len,0.1f);

  glNormal3f(-1,0,0);
  glVertex3f(-0.1f,0,0);
  glVertex3f(-0.1f,len,0);

  glNormal3f(0,0,-1);
  glVertex3f(0,0,-0.1f);
  glVertex3f(0,len,-0.1f);

  glNormal3f(1,0,0);
  glVertex3f(0.1f,0,0);
  glVertex3f(0.1f,len,0);
  glEnd();
}

void doLeg(float x1,float y1,float x2,float y2) {
  glPushMatrix();
  glTranslatef(x1,y1,0);
  glRotatef(atan2(x2-x1,y2-y1) RADIANS,0,0,-1);
  cylinder(hypot(x2-x1,y2-y1));
  glPopMatrix();
}

bool Player::update() {
  if ((speed || vspeed || deltaZ<0)) {// && !falling) {
    if (importance<20) importance += 5;
    implatency = 50;
  } else if (importance>1) {
    if (implatency) implatency--;
    else importance --;
  }

  if (deltaZ) {
    z += deltaZ; foot = -foot;
    if (z<-8) levelDone = true;

    if (z==0) deltaZ=0;
    else return true;
  }

  if (!falling) {
    if (speed) foot = -foot;
    x += speed;
  }
  y += vspeed;

  //  printf("vspeed %d y %d (%d), falling %d stopping %d floor %d cell-3.ladder %d\n",vspeed,y,((y+STEPS)%STEPS),falling,stopping,getCell()->getFloor(),getCell(-3)->getLadder());

  /* horizontal acceleration */
  if (stopping) {
    if (abs(speed)==1) {
      speed = 0;
    } else speed /= 2;
  } else if (abs(speed)==1) speed += speed;

  /* vertical acceleration */
  if (stopping && !falling) { // The player can't just "decide to stop falling"
    if (abs(vspeed)==1) {
      vspeed = 0;
    } else vspeed /= 2;
  } else {
    if (abs(vspeed)==1) vspeed += vspeed;
  }

  if (speed==0 && vspeed==0) stopping = false;

  /* Slow down if we're about to hit a floor (and aren't merrily
     walking down a ladder) (the (y+STEPS) can be understood as just
     (y) - it is to workaround the ((-3)%(2) = -1) bug) */
  if (vspeed<0 && getCell()->getFloor() && ((y+STEPS)%STEPS)+vspeed<=0 &&
      !(getCell(-3)->getLadder() && !falling) ) {
    //    printf("slowing down!\n");
    vspeed= -((y+STEPS)%STEPS);
    if (vspeed==0) falling = false;

  } else if (!falling && !(y%STEPS==0 && getCell()->getFloor()) &&
      !getCell()->getLadder()) {

    /* if nothing (neither a floor nor a ladder) supports us, then
       fall */

    falling = true; vspeed=-1;
    /* unless there's a floor immediately below, drop whatever we're
       carrying */
    if (held && !getCell()->getFloor()) grab(); // meaning, "release"
  }

  if (releasing && grab()) {
    releasing = false;
    stopping=true;
  }

  return (y >= -30);
}

void Player::stop() {
  stopping = true;
  releasing = false;
}

void Player::move(int direction) {
  speed = direction;
  if (!falling) vspeed = 0;
  stopping = false;
  releasing = false;
}

void Player::climb(int direction) {
  if (getCell(direction)->getLadder()) {
    vspeed = direction;
    speed = 0;
    stopping = false;
  } else if (getCell()->getDoor() && getCell()->getDoor()->isOpenedExit()) {
    deltaZ=-1;
  }
}

void Player::push(int direction) {
  if (!held) {
    Domino *d = getCell()->getDomino(0); // (Or could we push a vertical flyer attached to the ceiling?)
    if (d) {
      d->push(direction,0);
    }
  }
}

bool Player::grab() {
  if (held) {
    if (getCell()->getDomino(0) == &blank) {
      held->enter(getCell());
      held = 0;
      return true;
    } else {
      /* see if we can drop it nearby */
      Cell *c = level->getCell(getCell()->getX()+1,getCell()->getY());
      if ((c->getFloor() & 2) && (c->getDomino(0) == &blank) && (c->getDomino(1) == &blank)) {
	speed=1;
	releasing=true;
	return false;
      }
      c = level->getCell(getCell()->getX()-1,getCell()->getY());
      if ((c->getFloor() & 2) && (c->getDomino(0) == &blank) && (c->getDomino(1) == &blank)) {
	speed=-1;
	releasing=true;
	return false;
      }
    }
  } else {
    /* Empty handed. Try grabbing one */
    held = getCell()->getDomino(0);
    if (held) held = held->grab();
    return held!=0;
  }
  return false;
}

void Player::render(float t) {
  float rx,ry;
  float footspeed=(deltaZ?deltaZ:(((float)speed)*DOMSPC/STEPS))*foot;
  rx=(x+(falling||deltaZ?0.0f:(t*speed))-2)*DOMSPC/STEPS;
  ry=(y+t*vspeed)*CELLHEI/STEPS;

  //  if (speed || vspeed)
  lookAt(rx,ry,3);
  normCam(importance);
//   else
//     lookAt(rx,ry,10);

  glPushMatrix();
  //  printf("%d %d\n",x,y);
  glTranslatef(rx,ry,3+z+t*deltaZ);

  // domino
  if (held) {
    glPushMatrix();
    glRotatef(90,0,1,0);
    glTranslatef(-2,0,0);
    held->render(0);
    glPopMatrix();
  }

  glColor3f(0.9f,0.9f,0.9f);

  //  glPushMatrix();
  if (deltaZ) glRotatef(90,0,1,0);

  // left leg
  glPushMatrix();
  glTranslatef(0,0,-1);
  glRotatef(30,1,0,0);
  doLeg((t-0.5f)*footspeed,0,0,2);

//   glTranslatef(-1,0,0);
//   glRotatef(-30,0,0,1);
//   cylinder(2);
  glPopMatrix();

  // right leg
  glTranslatef(0,0,1);
  glRotatef(-30,1,0,0);
  doLeg((0.5f-t)*footspeed,0,0,2);
  //  glPushMatrix();
//   glTranslatef(1,0,0);
//   glRotatef(30,0,0,1);
//   cylinder(2);
  //  glPopMatrix();

  // trunk
  glTranslatef(0,2,0);
  glRotatef(30,1,0,0);
  //  glTranslatef(0,1.37f,0);
  cylinder(2.2f);

  if (deltaZ) glRotatef(90,0,1,0); // head always faces us

  // head
  glTranslatef(0,2.2f,0);
  glRotatef(75,0,0,1);
  for (int i=0;i<12;i++) {
    cylinder(0.51f);
    glTranslatef(0,0.5f,0);
    glRotatef(-30,0,0,1);
  }

  glPopMatrix();
}

Cell *Player::getCell(int dy) {
  if (dy>0) dy=0;
  return level->getCell((x-(x%STEPS))/STEPS,((y+dy)-((y+dy+STEPS)%STEPS))/STEPS);
}
