/* $Id: main_init.cpp,v 1.10 2004/07/27 13:17:13 baloo Exp $ */

#include "main.h"

#include "level.h"

#include "blocker.h"
#include "boomer.h"
#include "bridge.h"
#include "delay.h"
#include "flyer.h"
#include "looping.h"
#include "trigger.h"
#include "vanish.h"

GLuint tex_id;
int VideoFlags = 0;                 // Video Flags for the Create Window function
SDL_Surface * mainWindow = NULL;    // drawing surface on the SDL window

//Domino *dominos[DCOUNT];
//Cell cells[SWID][SHEI];

Player player = Player();

Level *level;
Blank blank;
Cell borderCell;
int levelnum=1;
bool levelDone=false;

bool init( int argc,char *argv[] )
{
  char pathname[11];

  borderCell.init(-2,-2,0,false);  

  if (snprintf(pathname,11,"levels/%d",levelnum)>=11) return false;
  level = new Level();
  if (!level->load(pathname)) return false;

  Door *wayIn = level->getWayIn();

  wayIn->open();

  player.init(wayIn->getCell());

//   /* Cells */
//   for (int y=0;y<SHEI;y++) {
//     if (y==2 || y==4)
//       cells[0][y].init(0,y,0,false);
//     else
//       cells[0][y].init(0,y,5,false);

//     for (int x=1;x<SWID;x++) {
//       bool l=(x==5); // ladder
//       if ((y==2 || y==4) && x<3)
// 	cells[x][y].init(x,y,0,l);
//       else if ((y==2 || y==4) && x==3)
// 	cells[x][y].init(x,y,5,l);
//       else if (((y==1||y==3) && x==12) || (x==16 && y>0 && y<5))
// 	cells[x][y].init(x,y,3,l);
//       else if (((y==1||y==3) && x==13) || (x==17 && y>0 && y<5))
// 	cells[x][y].init(x,y,0,l);
//       else if (((y==1||y==3) && x==14) || (x==18 && y>0 && y<5))
// 	cells[x][y].init(x,y,5,l);
//       else
// 	cells[x][y].init(x,y,7,l);
//     }
//   }

//   /* Dominoes */
//   for (int y=2;y<5;y++) {
//     for (int x=3;x<13;x++) {
//       putDom(new Domino(),x,y);
//     }
//   }

//   putDom(new Delay(),1,1);
//   putDom(new Delay(),13,0);

//   for (int i=2;i<11;i++) {
//     if (i==5 || i==9) {
//       putDom(new Domino(),i+1,1);
//     } else if (i==8 || i==7 || i==6) {
//       putDom(new Vanish(),i+1,1);
//     } else if (i==10) {
//       putDom(new Looping(),i+1,1);
//     } else {
//       putDom(new Delay(),i+1,1);
//     }
//   }

//   putDom(new Blocker(),1,3);
//   putDom(new Blocker(),14,2);
//   putDom(new Bridge(),12,1);

//   for (int i=0;i<11;i++) {
//     if (i==0)
//       putDom(new Trigger(),i+2,0);
//     else if (i==1)
//       putDom(new Vanish(),i+2,0);
//     else
//       putDom(new Domino(),i+2,0);
//   }

//   putDom(new Domino(),14,1);
//   putDom(new Looping(),15,1);
//   putDom(new Boomer(),16,1);
//   putDom(new Blocker(),19,0);
//   putDom(new Looping(),16,4);
//   putDom(new Flyer(),18,0);

//   printf("%d dominoes\n",dcount);

  if( SDL_Init( SDL_INIT_VIDEO ) < 0 )                // try to initialize SDL video module
    {
        cerr << "Failed initializing SDL Video : " << SDL_GetError() << endl;      // report error if it fails
    }

    VideoFlags    = SDL_OPENGL|SDL_HWPALETTE;

    const SDL_VideoInfo * VideoInfo = SDL_GetVideoInfo();     // query SDL for information about our video hardware

    if(VideoInfo == NULL)                                     // if this query fails
    {
        cerr << "Failed getting Video Info : " << SDL_GetError() << endl;          // report error
        exit(1);
    } 

    ///////////// we set the system dependant flags here
    if(VideoInfo -> hw_available)                      // is it a hardware surface
        VideoFlags |= SDL_HWSURFACE;
    else
        VideoFlags |= SDL_SWSURFACE;

    // Blitting is fast copying / moving /swapping of contiguous sections of memory
    // for more about blitting check out : http://www.csc.liv.ac.uk/~fish/HTML/blitzman/bm_blitter.html
    if(VideoInfo -> blit_hw)                            // is hardware blitting available
        VideoFlags |= SDL_HWACCEL;
 
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );      // tell SDL that the GL drawing is going to be double buffered
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE,   SCREEN_DEPTH);         // size of depth buffer 
    SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);       // we aren't going to use the stencil buffer
    SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);     // this and the next three lines set the bits allocated per pixel -
    SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);   // - for the accumulation buffer to 0
    SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
    SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);

    mainWindow = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH, VideoFlags);     // SCREEN_DEPTH is macro for bits per pixel

    if( mainWindow == NULL )                            // if window creation failed
    {
        cerr << "Failed to Create Window : " << SDL_GetError() << endl;         // report error 
        exit(2);
    } 

  // gouraud mode
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glShadeModel(GL_SMOOTH);          

  /*  glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
  glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
  glHint( GL_POLYGON_SMOOTH_HINT, GL_NICEST );
  glHint( GL_FOG_HINT, GL_NICEST );
  glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST ); 
  */

  glEnable(GL_NORMALIZE); // using scales for dominoes. This cancels them for normals

  glEnable(GL_LIGHTING);
  glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
  glEnable ( GL_COLOR_MATERIAL );
  glEnable ( GL_LIGHT0);

  glEnable (GL_BLEND); glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  glEnable(GL_TEXTURE_2D);
 
    // How Image data are stored in the GPU's memory    
    glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );   

    // Returns in texture_id the first integer of MAX_NUM_TEXTURES consecutive
    // unused integers for texture.
//     glGenTextures(1, &tex_id);

//     // Charge la texture dans la mmoire du gpu    

//     char pData[256*256*3];
//     int p=0;
//     for (int y=0;y<256;y++) for (int x=0;x<256;x++) {
//       pData[p++] = x&y;
//       pData[p++] = x&y;
//       pData[p++] = x&y;
//     }
        
//     glBindTexture(GL_TEXTURE_2D, tex_id);

//     glTexImage2D( GL_TEXTURE_2D, 0, 3, 256, 256, 
// 		  0, GL_RGB, GL_UNSIGNED_BYTE, pData );          

    
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT ); 
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
    
	//glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, tex->env_mode );  
    
    glClearDepth( 1.0f ); 
    glEnable( GL_DEPTH_TEST );
        
    glMatrixMode(GL_PROJECTION);                        // Select The Projection Matrix
    glLoadIdentity();                                   // Reset The Projection Matrix
 
                  // FOV        // Width Height Ratio   //  The farthest distance before it stops drawing)
    //gluPerspective( 45.0f, (GLfloat)width/(GLfloat)height, 1.0f, 10000.0f );
    glPerspective( 45.0f, (GLfloat)SCREEN_WIDTH/(GLfloat)SCREEN_HEIGHT, 1.0f, 10000.0f );
 
    glMatrixMode(GL_MODELVIEW);                         // Select The Modelview Matrix
    glLoadIdentity();                                   // Reset The Modelview Matrix
  //    Clock::instance()->startFrame();

    return true;
}
