/*  $Id: main.h,v 1.17 2004/07/27 13:17:13 baloo Exp $ */

#ifndef MAIN_H
#define MAIN_H

//#define DCOUNT 61

// in cell counts
//#define SWID 20
//#define SHEI 6

// how many miliseconds between two generations
#define TICK 50

// height of a domino
#define DOMHEI 5
// *half* width of a domino
#define DOMWID 0.5f

// spacing between two dominoes (width of a cell)
#define DOMSPC 5
// height of a cell
#define CELLHEI 10

#define FADETIME 1500

#include "base.h"
#include "player.h"
#include "level.h"
#include "blank.h"

/** The Pixel Format flags */
extern int VideoFlags;              
/** Our Drawable portion of the window */
extern SDL_Surface * mainWindow;     

extern GLuint tex_id;

//extern Domino *dominos[];
//extern Cell cells[SWID][SHEI];
extern Player player;
extern Level *level;
extern Blank blank;
/* the one cell being returned when you ask for one that's out of
   field. It's at coordinates (-2,-2) so that if you ask for its
   neighbours it will also be out of field and thus return itself. */
extern Cell borderCell;

extern int levelnum;
/* this is set to true by Player leaves the level, and tested in the
   mainLoop. */
extern bool levelDone;

/* Instructs the camera to try having (x,y) visible. visible should be
   a number larger or equal to 1. A very larg number means you mostly
   care to have the object visible. A low number means you also want
   to have it nicely in the centre and fill as much as possible of the
   screen. */
void lookAt(float x,float y,int visible);

/* see comments in main_mainLoop.cpp */
void normCam(int weight);

void updateCam();

/** This controls our MainLoop */
void mainLoop(void);

/** This initializes the whole program. */
bool init(int argc,char *argv[]);

#endif  // MAIN_H
