#include "looping.h"
#include "base.h"
#include "main.h"

Looping::Looping() {}

void Looping::land() {
  migrate(speed,0);
  angle = -angle;
}

// void Looping::update() {
//   //  printf("angle %d speed %d (%d,%d)->",angle,speed,cell->getX(),cell->getY());
//   Domino::update();
//   //  printf("->angle %d speed %d (%d,%d)\n",angle,speed,cell->getX(),cell->getY());
// }

void Looping::render(float t) {
  /* process push()es */
  //  printf("%d + %d + %d\n",accel,speed,angle);
  if (accel!=0) speed=accel;
  accel=0;

  glPushMatrix();

  // slightly slide the domino so that when it goes back up it is at the right place
  glTranslatef(((DOMSPC-DOMHEI)/2.0f-DOMWID)*angle/6.0f,0,0);

  rot(t);

  if (renderBroken(t)) {

    glBegin(GL_QUADS);
    glColor3f(1,1,0);
    glNormal3f(0,1,0); // top
    glVertex3f(-DOMWID,DOMHEI,-2);
    glVertex3f( DOMWID,DOMHEI,-2);
    glVertex3f( DOMWID,DOMHEI,2);
    glVertex3f(-DOMWID,DOMHEI,2);

    glNormal3f(0,-1,0); // bottom
    glVertex3f(-DOMWID,0,-2);
    glVertex3f( DOMWID,0,-2);
    glVertex3f( DOMWID,0, 2);
    glVertex3f(-DOMWID,0, 2);
    glEnd();

    glScalef(1,0.3333f,1);

    int g=1; // green component
    for (int i=0;i<3;i++) {

      glColor3f(1,g,0);
      glBegin(GL_QUADS);
      glNormal3f( 0,0, 1);
      glVertex3f(-DOMWID,0, 2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,0, 2);
      
      glNormal3f( 1,0, 0);
      glVertex3f( DOMWID,0, 2);
      glVertex3f( DOMWID,DOMHEI, 2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f( DOMWID,0,-2);
      
      glNormal3f( 0,0,-1);
      glVertex3f( DOMWID,0,-2);
      glVertex3f( DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,0,-2);
      
      glNormal3f(-1,0, 0);
      glVertex3f(-DOMWID,0,-2);
      glVertex3f(-DOMWID,DOMHEI,-2);
      glVertex3f(-DOMWID,DOMHEI, 2);
      glVertex3f(-DOMWID,0, 2);
      glEnd();
      
      glTranslatef(0,DOMHEI,0);
      g = 1-g;
    }
  }

  glPopMatrix();
}

Looping::~Looping() {

}
