#include "level.h"
#include "main.h"

#include "blocker.h"
#include "boomer.h"
#include "bridge.h"
#include "delay.h"
#include "domino.h"
#include "flyer.h"
#include "looping.h"
#include "splitter.h"
#include "trigger.h"
#include "vanish.h"

Level::Level() {
  wid=0;
  hei=0;
  cells=0;
  doms=0;
  dcount = 0;
}

Level::~Level() {
  for (int i=0;i<dcount;i++) {
    delete doms[i];
  }
  //  delete cells;
  delete doms;
}

Cell *Level::getCell(int x,int y) {
  if (x<0 || x>=wid || y<0 || y>=hei) return &borderCell;

  return &(cells[y*wid+x]);
}

/* Read a newline */
bool el(FILE *s) {
  char c;
  if (fread(&c,1,1,s)!=1) return false;
  if (c!='\n') {
    printf("Newline expected\n");
    return false;
  }
  return true;
}

bool Level::load(char *f) {
  FILE *s = fopen(f,"r");
  bool success = false;
  char c;
  int ix,iy,ox,oy;

  triggering = false;

  if (!s) return false;
  /* first line of a level file contains the field dimensions then way
     in position, then way out position. */
  if (fscanf(s,"%d %d %d %d %d %d",&wid,&hei,&ix,&iy,&ox,&oy) < 6) goto out;
  //  printf("%d x %d\n",wid,hei);
  cells = new Cell[wid*hei];
  /* We have at most that many dominoes... */
  doms = new Domino*[wid*hei];

  if (!el(s)) goto out;

  /* Read cells */
  for (int y=hei-1;y>=0;y--) {
    for (int x=0;x<wid;x++) {
      bool hasLadder;
      int hasFloor;
      if (fread(&c,1,1,s)!=1) goto out;
      //      printf(".%c",c);
      hasLadder = (c=='|' || c=='[' || c==']' || c=='!');
      switch (c) {
      case ' ': case '|':
	hasFloor=0;
	break;
      case '(': case '[':
	hasFloor=5;
	break;
      case ')': case ']':
	hasFloor=3;
	break;
      case '.': case ':':
	hasFloor=1;
	break;
      case '_': case '!':
	hasFloor=7;
	break;
      default:
	printf("Illegal cell character '%c'\n",c);
	goto out;
      }
      getCell(x,y)->init(x,y,hasFloor,hasLadder);
    }
    if (!el(s)) goto out;
    //    printf("\n");
  }

  /* read dominoes */
  for (int y=hei-1;y>=0;y--) {
    for (int x=0;x<wid;x++) {
      Domino *d;
      if (fread(&c,1,1,s)!=1) goto out;
      //      printf("#%c",c);
      switch (c) {
      case 'B':
	d = new Bridge();
	break;
      case 'D':
	d = new Delay();
	break;
      case 'F':
	d = new Flyer();
	break;
      case 'L':
	d = new Looping();
	break;
      case 'N':
	d = new Domino();
	break;
      case 'S':
	d = new Splitter();
	break;
      case 'T':
	d = new Trigger();
	break;
      case 'V':
	d = new Vanish();
	break;
      case 'W':
	d = new Blocker();
	break;
      case 'X':
	d = new Boomer();
	break;
      case ' ':
	continue;
      default:
	printf("Illegal domino character '%c'\n",c);
	goto out;
      }

      doms[dcount++] = d;

      d->init(getCell(x,y));
    }
    if (!el(s)) goto out;
    //    printf("\n");
  }

  wayIn.init(getCell(ix,iy),false);
  wayOut.init(getCell(ox,oy),true);

  success = true;

 out:
  fclose(s);
  return success;
}

void Level::render(float t) {
  /* LookAt the corners, to try having the full area visible */
  lookAt(0,0,1); //-wid*DOMSPC,-hei*CELLHEI,1);
  lookAt(wid*DOMSPC,hei*CELLHEI,1);

  normCam(4);

  for (int y=0;y<hei;y++) {
    glPushMatrix();
    for (int x=0;x<wid;x++) {
      getCell(x,y)->render(t);
      glTranslatef(DOMSPC,0,0);
    }
    glPopMatrix();
    glTranslatef(0,CELLHEI,0);
  }
  normCam(30); // the dominoes called lookAt from render()
}

void Level::update() {
  for (int i=0;i<dcount;i++) {
    doms[i]->update();
  }
  wayIn.update();
  wayOut.update();
  if (triggering) {
    triggering = false;
    for (int i=0;i<dcount;i++) {
      if (!doms[i]->isDone()) return;
    }
    wayOut.open();
  }
  //  printf("\n");
}

Door *Level::getWayIn() {
  return &wayIn;
}

void Level::openWayOut() {
  triggering = true;
}
