#include "flyer.h"
#include "base.h"
#include "main.h"

Flyer::Flyer() {}

/*bool Flyer::touch(int direction) {
  if (abs(angle)>4) return true;
  else return Domino::touch(direction);
  } */

/*bool Flyer::push(int direction,int from) {
  //  printf("flyer push angle %d direction %d from %d\n",angle,direction,from);
  if (abs(angle)>4) return Domino::push(direction,from);

  if (angle==0 && from==0) return push0(direction);
  else return (direction*from!=6);
  }*/

bool Flyer::push0(int direction) {
  if (elev==0) {
    fly=1;speed=direction;
    /* can't use migrate() because top is changing... */
    cell->leave(top);
    top=1;
    cell->enter(this,top);
  }
  return true;
}

void Flyer::update() {
  if (cell->getDomino(top) != this) return;

  /* if we are flying then stabilise in vertical position */
  if (fly==0 | (angle!=0))
    angle += speed;

  if (speed) {
    if (!touch(speed)) {// there's something blocking our progress
      if (speed*angle==4 && touch(-speed))
	/* bounce back */
	speed = -speed;
      else
	speed = 0;
    }
    if (angle*speed==6) land();
  } else if (angle!=0) {
    // we're not vertical - gravity makes us push towards sign(angle)
    if (angle>0 && angle<6 && touch(1)) speed=1;
    else if (angle<0 && angle>6 && touch(-1)) speed=-1;
  }

  /** Now deal with vertical motion */ 
  elev += fly;
  
  if (elev==0 && ! cell->getFloor()) {
    /* this one is triggered if we carry a domino and fall */
    fly=1;
  } else if (elev==2) {
    /* See if there's a ceiling above us */
    if (!level->getCell(cell->getX(),cell->getY()+1)->getFloor()) {
      fly=1;
      if (speed==0 && angle<0) speed=1;
      else if (speed==0 && angle>0) speed=-1;

      migrate(0,fly);
      elev -= 6;
    } else if (abs(angle)==6 && (speed*angle>=0) && ! level->getCell(cell->getX()+(angle/6),cell->getY()+1)->getFloor()) {
      fly=1;
      speed=angle/6;
      migrate(speed,fly);
      angle=-angle;
      elev -= 6;
    } else {
      fly=0;
    }
  }
}

void Flyer::render(float t) {
  glPushMatrix();

  /* TODO have Domino::rot take top into account to avoid this
     kludge */
  // the angle is interpreted the other way...
  glTranslatef(0,    DOMHEI/2,0.5f);
  glRotatef(180,1,0,0);
  glTranslatef(0,-1-DOMHEI/2,-0.5f);

  elev=-elev; // yes, dirty, I know
  fly = -fly;
  rot(t);
  fly = -fly;
  elev=-elev;

  //    glEnable(GL_LIGHTING);

  if (renderBroken(t)) {

    int g=1; // green component

    glScalef(DOMWID,DOMHEI,1/3.0f);

    glColor3f(1,1,0);
    glBegin(GL_QUADS);
    glNormal3f( 0,0, -1); // back
    glVertex3f(-1,0,-2);
    glVertex3f(-1,1,-2);
    glVertex3f( 1,1,-2);
    glVertex3f( 1,0,-2);

    glNormal3f( 0,0,1); // front
    glVertex3f(-1,0,10);
    glVertex3f(-1,1,10);
    glVertex3f( 1,1,10);
    glVertex3f( 1,0,10);
    glEnd();

    for (int i=0;i<3;i++) {

      glColor3f(1,g,0);
      glBegin(GL_QUADS);
      glNormal3f( 0, 1,0); // bottom
      glVertex3f(-1, 1,-2);
      glVertex3f(-1, 1,2);
      glVertex3f( 1, 1,2);
      glVertex3f( 1, 1,-2);
      
      glNormal3f( 1, 0,0);
      glVertex3f( 1, 1,-2);
      glVertex3f( 1, 1,2);
      glVertex3f( 1,0,2);
      glVertex3f( 1,0,-2);
      
      glNormal3f( 0,-1,0); // top
      glVertex3f( 1,0,-2);
      glVertex3f( 1,0,2);
      glVertex3f(-1,0,2);
      glVertex3f(-1,0,-2);
      
      glNormal3f(-1, 0,0);
      glVertex3f(-1,0,-2);
      glVertex3f(-1,0,2);
      glVertex3f(-1, 1,2);
      glVertex3f(-1, 1,-2);
      
      glEnd();
      
      glTranslatef(0,0,4);
      g = 1-g;
    }

  }

  glPopMatrix();
}

Flyer::~Flyer() {

}


