#ifndef DOOR_H
#define DOOR_H

class Door;

#include "cell.h"

/** A place where the player comes from at the beginning, or in which
    he leaves at the end */

class Door {
 public:

  Door();
  ~Door();

  /* exit: whether the player can *leave* through this door */
  void init(Cell *c,bool exit);

  void open();

  void update();

  void render(float t);

  bool isOpenedExit();

  Cell *getCell();

 private:
  Cell *c;
  bool exit;

  int angle; // 0 is closed, 6 is opened
  int speed; // 1 when it's opening
};

#endif
